/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.ftps;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.net.ftp.FTPSClient;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystemException;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystemOptions;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.ftp.FtpClientFactory;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.ftps.FtpsDataChannelProtectionLevel;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.ftps.FtpsFileSystemConfigBuilder;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.ftps.FtpsMode;
import java.io.IOException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;

public final class FtpsClientFactory {
    private FtpsClientFactory() {
    }

    public static FTPSClient createConnection(String hostname, int port, char[] username, char[] password, String workingDirectory, FileSystemOptions fileSystemOptions) throws FileSystemException {
        FtpsConnectionFactory factory = new FtpsConnectionFactory(FtpsFileSystemConfigBuilder.getInstance());
        return (FTPSClient)factory.createConnection(hostname, port, username, password, workingDirectory, fileSystemOptions);
    }

    private static final class FtpsConnectionFactory
    extends FtpClientFactory.ConnectionFactory<FTPSClient, FtpsFileSystemConfigBuilder> {
        private FtpsConnectionFactory(FtpsFileSystemConfigBuilder builder) {
            super(builder);
        }

        @Override
        protected FTPSClient createClient(FileSystemOptions fileSystemOptions) throws FileSystemException {
            KeyManager keyManager;
            FTPSClient client = ((FtpsFileSystemConfigBuilder)this.builder).getFtpsMode(fileSystemOptions) == FtpsMode.IMPLICIT ? new FTPSClient(true) : new FTPSClient();
            TrustManager trustManager = ((FtpsFileSystemConfigBuilder)this.builder).getTrustManager(fileSystemOptions);
            if (trustManager != null) {
                client.setTrustManager(trustManager);
            }
            if ((keyManager = ((FtpsFileSystemConfigBuilder)this.builder).getKeyManager(fileSystemOptions)) != null) {
                client.setKeyManager(keyManager);
            }
            return client;
        }

        @Override
        protected void setupOpenConnection(FTPSClient client, FileSystemOptions fileSystemOptions) throws IOException {
            FtpsDataChannelProtectionLevel level = ((FtpsFileSystemConfigBuilder)this.builder).getDataChannelProtectionLevel(fileSystemOptions);
            if (level != null) {
                try {
                    client.execPBSZ(0L);
                    client.execPROT(level.name());
                }
                catch (SSLException e) {
                    throw new FileSystemException("vfs.provider.ftps/data-channel.level", (Throwable)e, level.toString());
                }
            }
        }
    }
}

