/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.hdfs;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.Capability;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileName;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystem;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystemConfigBuilder;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystemException;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystemOptions;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.AbstractOriginatingFileProvider;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.hdfs.HdfsFileSystem;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.hdfs.HdfsFileSystemConfigBuilder;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.http.HttpFileNameParser;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public class HdfsFileProvider
extends AbstractOriginatingFileProvider {
    static final Collection<Capability> CAPABILITIES = Collections.unmodifiableCollection(Arrays.asList(Capability.GET_TYPE, Capability.READ_CONTENT, Capability.URI, Capability.GET_LAST_MODIFIED, Capability.ATTRIBUTES, Capability.RANDOM_ACCESS_READ, Capability.DIRECTORY_READ_CONTENT, Capability.LIST_CHILDREN));

    public HdfsFileProvider() {
        this.setFileNameParser(HttpFileNameParser.getInstance());
    }

    @Override
    protected FileSystem doCreateFileSystem(FileName rootName, FileSystemOptions fileSystemOptions) throws FileSystemException {
        return new HdfsFileSystem(rootName, fileSystemOptions);
    }

    @Override
    public Collection<Capability> getCapabilities() {
        return CAPABILITIES;
    }

    @Override
    public FileSystemConfigBuilder getConfigBuilder() {
        return HdfsFileSystemConfigBuilder.getInstance();
    }
}

