/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.http;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.httpclient.Header;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.httpclient.HeaderElement;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.httpclient.methods.HeadMethod;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileContent;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileContentInfo;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileContentInfoFactory;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystemException;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.impl.DefaultFileContentInfo;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.http.HttpFileObject;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.util.FileObjectUtils;
import java.io.IOException;

public class HttpFileContentInfoFactory
implements FileContentInfoFactory {
    @Override
    public FileContentInfo create(FileContent fileContent) throws FileSystemException {
        HeaderElement[] element;
        HeadMethod headMethod;
        String contentType = null;
        String contentEncoding = null;
        try (HttpFileObject httpFile = (HttpFileObject)FileObjectUtils.getAbstractFileObject(fileContent.getFile());){
            headMethod = httpFile.getHeadMethod();
        }
        catch (IOException e) {
            throw new FileSystemException(e);
        }
        Header header = headMethod.getResponseHeader("content-type");
        if (header != null && (element = header.getElements()) != null && element.length > 0) {
            contentType = element[0].getName();
        }
        contentEncoding = headMethod.getResponseCharSet();
        return new DefaultFileContentInfo(contentType, contentEncoding);
    }
}

