/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.http;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.httpclient.HttpClient;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.httpclient.HttpConnectionManager;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.Capability;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileObject;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystemOptions;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.AbstractFileName;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.AbstractFileSystem;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.GenericFileName;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.http.HttpFileObject;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.http.HttpFileProvider;
import java.util.Collection;

public class HttpFileSystem
extends AbstractFileSystem {
    private final HttpClient client;

    protected HttpFileSystem(GenericFileName rootName, HttpClient client, FileSystemOptions fileSystemOptions) {
        super(rootName, null, fileSystemOptions);
        this.client = client;
    }

    @Override
    protected void addCapabilities(Collection<Capability> caps) {
        caps.addAll(HttpFileProvider.capabilities);
    }

    protected HttpClient getClient() {
        return this.client;
    }

    @Override
    public void closeCommunicationLink() {
        HttpConnectionManager mgr;
        if (this.getClient() != null && (mgr = this.getClient().getHttpConnectionManager()) instanceof MultiThreadedHttpConnectionManager) {
            ((MultiThreadedHttpConnectionManager)mgr).shutdown();
        }
    }

    @Override
    protected FileObject createFile(AbstractFileName name) throws Exception {
        return new HttpFileObject<HttpFileSystem>(name, this);
    }
}

