/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.http4;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.Capability;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileName;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileObject;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystemOptions;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.AbstractFileName;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.AbstractFileSystem;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.http4.Http4FileObject;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.http4.Http4FileProvider;
import consulting.freiheitsgrade.patched.dependencies.org.apache.http.client.HttpClient;
import consulting.freiheitsgrade.patched.dependencies.org.apache.http.client.protocol.HttpClientContext;
import consulting.freiheitsgrade.patched.dependencies.org.apache.http.impl.client.CloseableHttpClient;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;

public class Http4FileSystem
extends AbstractFileSystem {
    private final URI internalBaseURI;
    private final HttpClient httpClient;
    private final HttpClientContext httpClientContext;

    protected Http4FileSystem(FileName rootName, FileSystemOptions fileSystemOptions, HttpClient httpClient, HttpClientContext httpClientContext) {
        super(rootName, null, fileSystemOptions);
        String rootURI = this.getRootURI();
        int offset = rootURI.indexOf(58);
        char lastCharOfScheme = offset > 0 ? rootURI.charAt(offset - 1) : (char)'\u0000';
        this.internalBaseURI = lastCharOfScheme == 's' || lastCharOfScheme == 'S' ? URI.create("https" + rootURI.substring(offset)) : URI.create("http" + rootURI.substring(offset));
        this.httpClient = httpClient;
        this.httpClientContext = httpClientContext;
    }

    @Override
    protected FileObject createFile(AbstractFileName name) throws Exception {
        return new Http4FileObject<Http4FileSystem>(name, this);
    }

    @Override
    protected void addCapabilities(Collection<Capability> caps) {
        caps.addAll(Http4FileProvider.capabilities);
    }

    @Override
    protected void doCloseCommunicationLink() {
        if (this.httpClient instanceof CloseableHttpClient) {
            try {
                ((CloseableHttpClient)this.httpClient).close();
            }
            catch (IOException e) {
                throw new RuntimeException("Error closing HttpClient", e);
            }
        }
    }

    protected HttpClient getHttpClient() {
        return this.httpClient;
    }

    protected HttpClientContext getHttpClientContext() {
        return this.httpClientContext;
    }

    protected URI getInternalBaseURI() {
        return this.internalBaseURI;
    }
}

