/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.http5;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileContent;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileContentInfo;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileContentInfoFactory;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystemException;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.impl.DefaultFileContentInfo;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.http5.Http5FileObject;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.util.FileObjectUtils;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hc.core5.http.ContentType;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hc.core5.http.Header;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hc.core5.http.HttpResponse;
import java.io.IOException;

public class Http5FileContentInfoFactory
implements FileContentInfoFactory {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FileContentInfo create(FileContent fileContent) throws FileSystemException {
        String contentMimeType = null;
        String contentCharset = null;
        try (Http5FileObject http4File = (Http5FileObject)FileObjectUtils.getAbstractFileObject(fileContent.getFile());){
            HttpResponse lastHeadResponse = http4File.getLastHeadResponse();
            Header header = lastHeadResponse.getFirstHeader("Content-Type");
            if (header != null) {
                ContentType contentType = ContentType.parse((CharSequence)header.getValue());
                contentMimeType = contentType.getMimeType();
                if (contentType.getCharset() != null) {
                    contentCharset = contentType.getCharset().name();
                }
            }
            DefaultFileContentInfo defaultFileContentInfo = new DefaultFileContentInfo(contentMimeType, contentCharset);
            return defaultFileContentInfo;
        }
        catch (IOException e) {
            throw new FileSystemException(e);
        }
    }
}

