/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.http5;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.Capability;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileName;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystem;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystemConfigBuilder;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystemException;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystemOptions;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.UserAuthenticationData;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.UserAuthenticator;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.AbstractOriginatingFileProvider;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.GenericFileName;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.http5.Http5FileNameParser;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.http5.Http5FileSystem;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.http5.Http5FileSystemConfigBuilder;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.util.UserAuthenticatorUtils;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hc.client5.http.auth.AuthCache;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hc.client5.http.auth.AuthScheme;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hc.client5.http.auth.AuthScope;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hc.client5.http.auth.Credentials;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hc.client5.http.auth.CredentialsProvider;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hc.client5.http.classic.HttpClient;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hc.client5.http.config.RequestConfig;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hc.client5.http.cookie.BasicCookieStore;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hc.client5.http.cookie.Cookie;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hc.client5.http.cookie.CookieStore;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hc.client5.http.impl.auth.BasicAuthCache;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hc.client5.http.impl.auth.BasicScheme;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hc.client5.http.impl.classic.HttpClients;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hc.client5.http.impl.routing.DefaultProxyRoutePlanner;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hc.client5.http.impl.routing.SystemDefaultRoutePlanner;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hc.client5.http.io.HttpClientConnectionManager;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hc.client5.http.protocol.HttpClientContext;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hc.client5.http.routing.HttpRoutePlanner;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hc.client5.http.ssl.DefaultHostnameVerifier;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hc.client5.http.ssl.SSLConnectionSocketFactoryBuilder;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hc.client5.http.ssl.TrustAllStrategy;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hc.core5.http.ConnectionReuseStrategy;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hc.core5.http.HttpHost;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hc.core5.http.HttpRequest;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hc.core5.http.HttpResponse;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hc.core5.http.impl.DefaultConnectionReuseStrategy;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hc.core5.http.io.SocketConfig;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hc.core5.http.message.BasicHeader;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hc.core5.http.protocol.HttpContext;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hc.core5.http.ssl.TLS;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hc.core5.ssl.SSLContextBuilder;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hc.core5.ssl.TrustStrategy;
import java.io.File;
import java.io.IOException;
import java.net.ProxySelector;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;

public class Http5FileProvider
extends AbstractOriginatingFileProvider {
    static final UserAuthenticationData.Type[] AUTHENTICATOR_TYPES = new UserAuthenticationData.Type[]{UserAuthenticationData.USERNAME, UserAuthenticationData.PASSWORD};
    static final Collection<Capability> capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.GET_TYPE, Capability.READ_CONTENT, Capability.URI, Capability.GET_LAST_MODIFIED, Capability.ATTRIBUTES, Capability.RANDOM_ACCESS_READ, Capability.DIRECTORY_READ_CONTENT));

    public Http5FileProvider() {
        this.setFileNameParser(Http5FileNameParser.getInstance());
    }

    @Override
    public FileSystemConfigBuilder getConfigBuilder() {
        return Http5FileSystemConfigBuilder.getInstance();
    }

    @Override
    public Collection<Capability> getCapabilities() {
        return capabilities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected FileSystem doCreateFileSystem(FileName name, FileSystemOptions fileSystemOptions) throws FileSystemException {
        GenericFileName rootName = (GenericFileName)name;
        UserAuthenticationData authData = null;
        HttpClient httpClient = null;
        HttpClientContext httpClientContext = null;
        try {
            Http5FileSystemConfigBuilder builder = Http5FileSystemConfigBuilder.getInstance();
            authData = UserAuthenticatorUtils.authenticate(fileSystemOptions, AUTHENTICATOR_TYPES);
            httpClientContext = this.createHttpClientContext(builder, rootName, fileSystemOptions, authData);
            httpClient = this.createHttpClient(builder, rootName, fileSystemOptions);
        }
        catch (Throwable throwable) {
            UserAuthenticatorUtils.cleanup(authData);
            throw throwable;
        }
        UserAuthenticatorUtils.cleanup(authData);
        return new Http5FileSystem(rootName, fileSystemOptions, httpClient, httpClientContext);
    }

    protected HttpClient createHttpClient(Http5FileSystemConfigBuilder builder, GenericFileName rootName, FileSystemOptions fileSystemOptions) throws FileSystemException {
        return this.createHttpClientBuilder(builder, rootName, fileSystemOptions).build();
    }

    protected HttpClientBuilder createHttpClientBuilder(Http5FileSystemConfigBuilder builder, GenericFileName rootName, FileSystemOptions fileSystemOptions) throws FileSystemException {
        ArrayList<BasicHeader> defaultHeaders = new ArrayList<BasicHeader>();
        defaultHeaders.add(new BasicHeader("User-Agent", (Object)builder.getUserAgent(fileSystemOptions)));
        Object connectionReuseStrategy = builder.isKeepAlive(fileSystemOptions) ? DefaultConnectionReuseStrategy.INSTANCE : new ConnectionReuseStrategy(){

            public boolean keepAlive(HttpRequest request, HttpResponse response, HttpContext context) {
                return false;
            }
        };
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setRoutePlanner(this.createHttpRoutePlanner(builder, fileSystemOptions)).setConnectionManager(this.createConnectionManager(builder, fileSystemOptions)).setConnectionReuseStrategy((ConnectionReuseStrategy)connectionReuseStrategy).setDefaultRequestConfig(this.createDefaultRequestConfig(builder, fileSystemOptions)).setDefaultHeaders(defaultHeaders).setDefaultCookieStore(this.createDefaultCookieStore(builder, fileSystemOptions));
        if (!builder.getFollowRedirect(fileSystemOptions)) {
            httpClientBuilder.disableRedirectHandling();
        }
        return httpClientBuilder;
    }

    protected SSLContext createSSLContext(Http5FileSystemConfigBuilder builder, FileSystemOptions fileSystemOptions) throws FileSystemException {
        try {
            SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
            File keystoreFileObject = null;
            String keystoreFile = builder.getKeyStoreFile(fileSystemOptions);
            if (keystoreFile != null && !keystoreFile.isEmpty()) {
                keystoreFileObject = new File(keystoreFile);
            }
            if (keystoreFileObject != null && keystoreFileObject.exists()) {
                String keystorePass = builder.getKeyStorePass(fileSystemOptions);
                char[] keystorePassChars = keystorePass != null ? keystorePass.toCharArray() : null;
                sslContextBuilder.loadTrustMaterial(keystoreFileObject, keystorePassChars, (TrustStrategy)TrustAllStrategy.INSTANCE);
            } else {
                sslContextBuilder.loadTrustMaterial((TrustStrategy)TrustAllStrategy.INSTANCE);
            }
            return sslContextBuilder.build();
        }
        catch (KeyStoreException e) {
            throw new FileSystemException("Keystore error. " + e.getMessage(), e);
        }
        catch (KeyManagementException e) {
            throw new FileSystemException("Cannot retrieve keys. " + e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new FileSystemException("Algorithm error. " + e.getMessage(), e);
        }
        catch (CertificateException e) {
            throw new FileSystemException("Certificate error. " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new FileSystemException("Cannot open key file. " + e.getMessage(), e);
        }
    }

    protected HttpClientContext createHttpClientContext(Http5FileSystemConfigBuilder builder, GenericFileName rootName, FileSystemOptions fileSystemOptions, UserAuthenticationData authData) throws FileSystemException {
        UserAuthenticator proxyAuth;
        HttpHost proxyHost;
        HttpClientContext clientContext = HttpClientContext.create();
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        clientContext.setCredentialsProvider((CredentialsProvider)credsProvider);
        String username = UserAuthenticatorUtils.toString(UserAuthenticatorUtils.getData(authData, UserAuthenticationData.USERNAME, UserAuthenticatorUtils.toChar(rootName.getUserName())));
        char[] password = UserAuthenticatorUtils.getData(authData, UserAuthenticationData.PASSWORD, UserAuthenticatorUtils.toChar(rootName.getPassword()));
        if (username != null && !username.isEmpty()) {
            credsProvider.setCredentials(new AuthScope(rootName.getHostName(), -1), (Credentials)new UsernamePasswordCredentials(username, password));
        }
        if ((proxyHost = this.getProxyHttpHost(builder, fileSystemOptions)) != null && (proxyAuth = builder.getProxyAuthenticator(fileSystemOptions)) != null) {
            UserAuthenticationData proxyAuthData = UserAuthenticatorUtils.authenticate(proxyAuth, new UserAuthenticationData.Type[]{UserAuthenticationData.USERNAME, UserAuthenticationData.PASSWORD});
            if (proxyAuthData != null) {
                UsernamePasswordCredentials proxyCreds = new UsernamePasswordCredentials(UserAuthenticatorUtils.toString(UserAuthenticatorUtils.getData(authData, UserAuthenticationData.USERNAME, null)), UserAuthenticatorUtils.getData(authData, UserAuthenticationData.PASSWORD, null));
                credsProvider.setCredentials(new AuthScope(proxyHost.getHostName(), -1), (Credentials)proxyCreds);
            }
            if (builder.isPreemptiveAuth(fileSystemOptions)) {
                BasicAuthCache authCache = new BasicAuthCache();
                BasicScheme basicAuth = new BasicScheme();
                authCache.put(proxyHost, (AuthScheme)basicAuth);
                clientContext.setAuthCache((AuthCache)authCache);
            }
        }
        return clientContext;
    }

    private HttpClientConnectionManager createConnectionManager(Http5FileSystemConfigBuilder builder, FileSystemOptions fileSystemOptions) throws FileSystemException {
        SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(builder.getSoTimeout(fileSystemOptions), TimeUnit.MILLISECONDS).build();
        String[] tlsVersions = builder.getTlsVersions(fileSystemOptions).split("\\s*,\\s*");
        TLS[] tlsArray = new TLS[tlsVersions.length];
        for (int i = 0; i < tlsVersions.length; ++i) {
            tlsArray[i] = TLS.valueOf((String)tlsVersions[i]);
        }
        SSLConnectionSocketFactory sslSocketFactory = SSLConnectionSocketFactoryBuilder.create().setSslContext(this.createSSLContext(builder, fileSystemOptions)).setHostnameVerifier(this.createHostnameVerifier(builder, fileSystemOptions)).setTlsVersions(tlsArray).build();
        return PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory).setMaxConnTotal(builder.getMaxTotalConnections(fileSystemOptions)).setMaxConnPerRoute(builder.getMaxConnectionsPerHost(fileSystemOptions)).setDefaultSocketConfig(socketConfig).build();
    }

    private RequestConfig createDefaultRequestConfig(Http5FileSystemConfigBuilder builder, FileSystemOptions fileSystemOptions) {
        return RequestConfig.custom().setConnectTimeout((long)builder.getConnectionTimeout(fileSystemOptions), TimeUnit.MILLISECONDS).build();
    }

    private HttpRoutePlanner createHttpRoutePlanner(Http5FileSystemConfigBuilder builder, FileSystemOptions fileSystemOptions) {
        HttpHost proxyHost = this.getProxyHttpHost(builder, fileSystemOptions);
        if (proxyHost != null) {
            return new DefaultProxyRoutePlanner(proxyHost);
        }
        return new SystemDefaultRoutePlanner(ProxySelector.getDefault());
    }

    private HttpHost getProxyHttpHost(Http5FileSystemConfigBuilder builder, FileSystemOptions fileSystemOptions) {
        String proxyHost = builder.getProxyHost(fileSystemOptions);
        int proxyPort = builder.getProxyPort(fileSystemOptions);
        if (proxyHost != null && proxyHost.length() > 0 && proxyPort > 0) {
            return new HttpHost(proxyHost, proxyPort);
        }
        return null;
    }

    private CookieStore createDefaultCookieStore(Http5FileSystemConfigBuilder builder, FileSystemOptions fileSystemOptions) {
        BasicCookieStore cookieStore = new BasicCookieStore();
        Cookie[] cookies = builder.getCookies(fileSystemOptions);
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                cookieStore.addCookie(cookie);
            }
        }
        return cookieStore;
    }

    private HostnameVerifier createHostnameVerifier(Http5FileSystemConfigBuilder builder, FileSystemOptions fileSystemOptions) throws FileSystemException {
        if (!builder.isHostnameVerificationEnabled(fileSystemOptions)) {
            return NoopHostnameVerifier.INSTANCE;
        }
        return new DefaultHostnameVerifier();
    }
}

