/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.http5;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystemException;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.AbstractRandomAccessStreamContent;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.http5.Http5FileObject;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.http5.Http5FileSystem;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.http5.MonitoredHttpResponseContentInputStream;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.util.MonitorInputStream;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.util.RandomAccessMode;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hc.client5.http.classic.methods.HttpGet;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hc.core5.http.ClassicHttpResponse;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;

class Http5RandomAccessContent<FS extends Http5FileSystem>
extends AbstractRandomAccessStreamContent {
    protected long filePointer = 0L;
    private final Http5FileObject<FS> fileObject;
    private DataInputStream dis = null;
    private MonitorInputStream mis = null;

    Http5RandomAccessContent(Http5FileObject<FS> fileObject, RandomAccessMode mode) {
        super(mode);
        this.fileObject = fileObject;
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.filePointer;
    }

    @Override
    public void seek(long pos) throws IOException {
        if (pos == this.filePointer) {
            return;
        }
        if (pos < 0L) {
            throw new FileSystemException("vfs.provider/random-access-invalid-position.error", (Object)pos);
        }
        if (this.dis != null) {
            this.close();
        }
        this.filePointer = pos;
    }

    @Override
    protected DataInputStream getDataInputStream() throws IOException {
        long skipped;
        if (this.dis != null) {
            return this.dis;
        }
        HttpGet httpGet = new HttpGet(this.fileObject.getInternalURI());
        httpGet.setHeader("Range", (Object)("bytes=" + this.filePointer + "-"));
        ClassicHttpResponse httpResponse = this.fileObject.executeHttpUriRequest((HttpUriRequest)httpGet);
        int status = httpResponse.getCode();
        if (status != 206 && status != 200) {
            throw new FileSystemException("vfs.provider.http/get-range.error", this.fileObject.getName(), this.filePointer, status);
        }
        this.mis = new MonitoredHttpResponseContentInputStream(httpResponse);
        if (status == 200 && (skipped = this.mis.skip(this.filePointer)) != this.filePointer) {
            throw new FileSystemException("vfs.provider.http/get-range.error", this.fileObject.getName(), this.filePointer, status);
        }
        this.dis = new DataInputStream(new FilterInputStream(this.mis){

            @Override
            public int read() throws IOException {
                int ret = super.read();
                if (ret > -1) {
                    ++Http5RandomAccessContent.this.filePointer;
                }
                return ret;
            }

            @Override
            public int read(byte[] b) throws IOException {
                int ret = super.read(b);
                if (ret > -1) {
                    Http5RandomAccessContent.this.filePointer += (long)ret;
                }
                return ret;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int ret = super.read(b, off, len);
                if (ret > -1) {
                    Http5RandomAccessContent.this.filePointer += (long)ret;
                }
                return ret;
            }
        });
        return this.dis;
    }

    @Override
    public void close() throws IOException {
        if (this.dis != null) {
            this.dis.close();
            this.dis = null;
            this.mis = null;
        }
    }

    @Override
    public long length() throws IOException {
        return this.fileObject.getContent().getSize();
    }
}

