/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.jar;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.Capability;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileObject;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystem;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystemException;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystemOptions;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileType;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.LayeredFileName;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.jar.JarFileSystem;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.zip.ZipFileProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public class JarFileProvider
extends ZipFileProvider {
    static final Collection<Capability> capabilities;

    @Override
    protected FileSystem doCreateFileSystem(String scheme, FileObject file, FileSystemOptions fileSystemOptions) throws FileSystemException {
        LayeredFileName name = new LayeredFileName(scheme, file.getName(), "/", FileType.FOLDER);
        return new JarFileSystem(name, file, fileSystemOptions);
    }

    @Override
    public Collection<Capability> getCapabilities() {
        return capabilities;
    }

    static {
        ArrayList<Capability> combined = new ArrayList<Capability>();
        combined.addAll(ZipFileProvider.capabilities);
        combined.addAll(Arrays.asList(Capability.ATTRIBUTES, Capability.FS_ATTRIBUTES, Capability.SIGNING, Capability.MANIFEST_ATTRIBUTES, Capability.VIRTUAL));
        capabilities = Collections.unmodifiableCollection(combined);
    }
}

