/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.jar;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileContent;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystemException;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.jar.JarFileObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.Certificate;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class JarURLConnectionImpl
extends JarURLConnection {
    private static final String HACK_URL = "jar:http://somehost/somejar.jar!/";
    private final FileContent content;
    private final URL parentURL;
    private final JarFileObject file;
    private final String entryName;

    public JarURLConnectionImpl(JarFileObject file, FileContent content) throws MalformedURLException, FileSystemException {
        super(new URL(HACK_URL));
        this.url = file.getURL();
        this.content = content;
        this.parentURL = file.getURL();
        this.entryName = file.getName().getPath();
        this.file = file;
    }

    @Override
    public URL getJarFileURL() {
        return this.parentURL;
    }

    @Override
    public String getEntryName() {
        return this.entryName;
    }

    @Override
    public JarFile getJarFile() throws IOException {
        throw new FileSystemException("vfs.provider.jar/jar-file-no-access.error");
    }

    @Override
    public Manifest getManifest() throws IOException {
        return this.file.getManifest();
    }

    @Override
    public JarEntry getJarEntry() throws IOException {
        throw new FileSystemException("vfs.provider.jar/jar-entry-no-access.error");
    }

    @Override
    public Attributes getAttributes() throws IOException {
        return this.file.getAttributes();
    }

    @Override
    public Certificate[] getCertificates() {
        return this.file.doGetCertificates();
    }

    @Override
    public void connect() {
        this.connected = true;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.content.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.content.getOutputStream();
    }

    @Override
    public int getContentLength() {
        try {
            return (int)this.content.getSize();
        }
        catch (FileSystemException ignored) {
            return -1;
        }
    }
}

