/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.local;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileName;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystemException;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileType;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.AbstractFileNameParser;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.UriParser;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.VfsComponentContext;
import java.net.URI;

public abstract class LocalFileNameParser
extends AbstractFileNameParser {
    public boolean isAbsoluteName(String name) {
        StringBuilder b = new StringBuilder(name);
        try {
            UriParser.fixSeparators(b);
            this.extractRootPrefix(name, b);
            return true;
        }
        catch (FileSystemException e) {
            return false;
        }
    }

    protected abstract String extractRootPrefix(String var1, StringBuilder var2) throws FileSystemException;

    @Override
    public FileName parseUri(VfsComponentContext context, FileName base, String uri) throws FileSystemException {
        StringBuilder name = new StringBuilder();
        String scheme = UriParser.extractScheme(this.getSchemes(context, base, uri), uri, name);
        if (scheme == null && base != null) {
            scheme = base.getScheme();
        }
        if (scheme == null) {
            scheme = "file";
        }
        UriParser.canonicalizePath(name, 0, name.length(), this);
        UriParser.fixSeparators(name);
        String rootFile = this.extractRootPrefix(uri, name);
        FileType fileType = UriParser.normalisePath(name);
        String path = name.toString();
        return this.createFileName(scheme, rootFile, path, fileType);
    }

    private String[] getSchemes(VfsComponentContext context, FileName base, String uri) {
        if (context == null) {
            return new String[]{base != null ? base.getScheme() : URI.create(uri).getScheme()};
        }
        return context.getFileSystemManager().getSchemes();
    }

    protected abstract FileName createFileName(String var1, String var2, String var3, FileType var4);
}

