/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.local;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.Capability;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileName;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileObject;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSelector;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystemException;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystemOptions;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.AbstractFileName;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.AbstractFileSystem;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.local.DefaultLocalFileProvider;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.local.LocalFile;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.util.FileObjectUtils;
import java.io.File;
import java.io.FilePermission;
import java.util.Collection;

public class LocalFileSystem
extends AbstractFileSystem {
    private final String rootFile;

    public LocalFileSystem(FileName rootName, String rootFile, FileSystemOptions opts) {
        super(rootName, null, opts);
        this.rootFile = rootFile;
    }

    @Override
    protected FileObject createFile(AbstractFileName name) throws FileSystemException {
        return new LocalFile(this, this.rootFile, name);
    }

    @Override
    protected void addCapabilities(Collection<Capability> caps) {
        caps.addAll(DefaultLocalFileProvider.capabilities);
    }

    @Override
    protected File doReplicateFile(FileObject fileObject, FileSelector selector) throws Exception {
        LocalFile localFile = (LocalFile)FileObjectUtils.getAbstractFileObject(fileObject);
        File file = localFile.getLocalFile();
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            FilePermission requiredPerm = new FilePermission(file.getAbsolutePath(), "read");
            sm.checkPermission(requiredPerm);
        }
        return file;
    }
}

