/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.local;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileName;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystemException;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileType;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.local.LocalFileNameParser;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.local.WindowsFileName;

public class WindowsFileNameParser
extends LocalFileNameParser {
    @Override
    protected String extractRootPrefix(String uri, StringBuilder name) throws FileSystemException {
        return this.extractWindowsRootPrefix(uri, name);
    }

    @Override
    protected FileName createFileName(String scheme, String rootFile, String path, FileType type) {
        return new WindowsFileName(scheme, rootFile, path, type);
    }

    private String extractWindowsRootPrefix(String uri, StringBuilder name) throws FileSystemException {
        int startPos;
        int maxlen = Math.min(4, name.length());
        for (startPos = 0; startPos < maxlen && name.charAt(startPos) == '/'; ++startPos) {
        }
        if (startPos == maxlen && name.length() > startPos + 1 && name.charAt(startPos + 1) == '/') {
            throw new FileSystemException("vfs.provider.local/not-absolute-file-name.error", (Object)uri);
        }
        name.delete(0, startPos);
        String driveName = this.extractDrivePrefix(name);
        if (driveName != null) {
            return driveName;
        }
        if (startPos < 2) {
            throw new FileSystemException("vfs.provider.local/not-absolute-file-name.error", (Object)uri);
        }
        return "//" + this.extractUNCPrefix(uri, name);
    }

    private String extractDrivePrefix(StringBuilder name) {
        if (name.length() < 3) {
            return null;
        }
        char ch = name.charAt(0);
        if (ch == '/' || ch == ':') {
            return null;
        }
        if (name.charAt(1) != ':') {
            return null;
        }
        if (name.charAt(2) != '/') {
            return null;
        }
        String prefix = name.substring(0, 2);
        name.delete(0, 2);
        return prefix.intern();
    }

    private String extractUNCPrefix(String uri, StringBuilder name) throws FileSystemException {
        int pos;
        int maxpos = name.length();
        for (pos = 0; pos < maxpos && name.charAt(pos) != '/'; ++pos) {
        }
        if (++pos >= maxpos) {
            throw new FileSystemException("vfs.provider.local/missing-share-name.error", (Object)uri);
        }
        int startShareName = pos;
        while (pos < maxpos && name.charAt(pos) != '/') {
            ++pos;
        }
        if (pos == startShareName) {
            throw new FileSystemException("vfs.provider.local/missing-share-name.error", (Object)uri);
        }
        String prefix = name.substring(0, pos);
        name.delete(0, pos);
        return prefix;
    }
}

