/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.ram;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileObject;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystemException;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystemOptions;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileType;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.RandomAccessContent;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.AbstractFileName;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.AbstractFileObject;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.ram.RamFileData;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.ram.RamFileOutputStream;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.ram.RamFileRandomAccessContent;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.ram.RamFileSystem;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.ram.RamFileSystemConfigBuilder;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.util.FileObjectUtils;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.util.RandomAccessMode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class RamFileObject
extends AbstractFileObject<RamFileSystem> {
    private RamFileData data;

    protected RamFileObject(AbstractFileName name, RamFileSystem fs) {
        super(name, fs);
        ((RamFileSystem)this.getAbstractFileSystem()).attach(this);
    }

    private void save() throws FileSystemException {
        ((RamFileSystem)this.getAbstractFileSystem()).save(this);
    }

    @Override
    protected FileType doGetType() throws Exception {
        return this.data.getType();
    }

    @Override
    protected String[] doListChildren() throws Exception {
        return ((RamFileSystem)this.getAbstractFileSystem()).listChildren(this.getName());
    }

    @Override
    protected long doGetContentSize() throws Exception {
        return this.size();
    }

    @Override
    protected InputStream doGetInputStream(int bufferSize) throws Exception {
        if (!this.getType().hasContent()) {
            throw new FileSystemException("vfs.provider/read-not-file.error", (Object)this.getName());
        }
        return new ByteArrayInputStream(this.data.getContent());
    }

    @Override
    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        if (!bAppend) {
            this.data.setContent(RamFileData.EMPTY);
        }
        return new RamFileOutputStream(this);
    }

    @Override
    protected void doDelete() throws Exception {
        if (this.isContentOpen()) {
            throw new FileSystemException(this.getName() + " cannot be deleted while the file is openg");
        }
        ((RamFileSystem)this.getAbstractFileSystem()).delete(this);
    }

    @Override
    protected long doGetLastModifiedTime() throws Exception {
        return this.data.getLastModified();
    }

    @Override
    protected boolean doSetLastModifiedTime(long modtime) throws Exception {
        this.data.setLastModified(modtime);
        return true;
    }

    @Override
    protected void doCreateFolder() throws Exception {
        this.injectType(FileType.FOLDER);
        this.save();
    }

    @Override
    protected void doRename(FileObject newFile) throws Exception {
        RamFileObject newRamFileObject = (RamFileObject)FileObjectUtils.getAbstractFileObject(newFile);
        ((RamFileSystem)this.getAbstractFileSystem()).rename(this, newRamFileObject);
    }

    @Override
    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode mode) throws Exception {
        return new RamFileRandomAccessContent(this, mode);
    }

    @Override
    protected void doAttach() throws Exception {
        ((RamFileSystem)this.getAbstractFileSystem()).attach(this);
    }

    RamFileData getData() {
        return this.data;
    }

    void setData(RamFileData data) {
        this.data = data;
    }

    @Override
    protected void injectType(FileType fileType) {
        this.data.setType(fileType);
        super.injectType(fileType);
    }

    @Override
    protected void endOutput() throws Exception {
        super.endOutput();
        this.save();
    }

    int size() {
        return this.data == null ? 0 : this.data.size();
    }

    synchronized void resize(long newSize) throws IOException {
        RamFileSystem afs = (RamFileSystem)this.getAbstractFileSystem();
        FileSystemOptions afsOptions = afs.getFileSystemOptions();
        if (afsOptions != null) {
            long maxSize = RamFileSystemConfigBuilder.getInstance().getLongMaxSize(afsOptions);
            if (afs.size() + newSize - (long)this.size() > maxSize) {
                throw new IOException("FileSystem capacity (" + maxSize + ") exceeded.");
            }
        }
        this.data.resize(newSize);
    }
}

