/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.sftp;

import consulting.freiheitsgrade.patched.dependencies.com.jcraft.jsch.ConfigRepository;
import consulting.freiheitsgrade.patched.dependencies.com.jcraft.jsch.JSch;
import consulting.freiheitsgrade.patched.dependencies.com.jcraft.jsch.JSchException;
import consulting.freiheitsgrade.patched.dependencies.com.jcraft.jsch.Logger;
import consulting.freiheitsgrade.patched.dependencies.com.jcraft.jsch.OpenSSHConfig;
import consulting.freiheitsgrade.patched.dependencies.com.jcraft.jsch.Proxy;
import consulting.freiheitsgrade.patched.dependencies.com.jcraft.jsch.ProxyHTTP;
import consulting.freiheitsgrade.patched.dependencies.com.jcraft.jsch.ProxySOCKS5;
import consulting.freiheitsgrade.patched.dependencies.com.jcraft.jsch.Session;
import consulting.freiheitsgrade.patched.dependencies.com.jcraft.jsch.UserInfo;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.logging.Log;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.logging.LogFactory;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystemException;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystemOptions;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.sftp.IdentityInfo;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.sftp.IdentityProvider;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.sftp.IdentityRepositoryFactory;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.sftp.SftpFileSystemConfigBuilder;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.sftp.SftpStreamProxy;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.util.Os;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public final class SftpClientFactory {
    private static final String SSH_DIR_NAME = ".ssh";
    private static final String OPENSSH_CONFIG_NAME = "config";
    private static final Log LOG = LogFactory.getLog(SftpClientFactory.class);

    private SftpClientFactory() {
    }

    public static Session createConnection(String hostname, int port, char[] username, char[] password, FileSystemOptions fileSystemOptions) throws FileSystemException {
        Session session;
        JSch jsch = new JSch();
        File sshDir = null;
        SftpFileSystemConfigBuilder builder = SftpFileSystemConfigBuilder.getInstance();
        File knownHostsFile = builder.getKnownHosts(fileSystemOptions);
        IdentityProvider[] identities = builder.getIdentityProvider(fileSystemOptions);
        IdentityRepositoryFactory repositoryFactory = builder.getIdentityRepositoryFactory(fileSystemOptions);
        ConfigRepository configRepository = builder.getConfigRepository(fileSystemOptions);
        boolean loadOpenSSHConfig = builder.isLoadOpenSSHConfig(fileSystemOptions);
        sshDir = SftpClientFactory.findSshDir();
        SftpClientFactory.setKnownHosts(jsch, sshDir, knownHostsFile);
        if (repositoryFactory != null) {
            jsch.setIdentityRepository(repositoryFactory.create(jsch));
        }
        SftpClientFactory.addIdentities(jsch, sshDir, identities);
        SftpClientFactory.setConfigRepository(jsch, sshDir, configRepository, loadOpenSSHConfig);
        try {
            String proxyHost;
            String keyExchangeAlgorithm;
            String compression;
            String preferredAuthentications;
            UserInfo userInfo;
            Integer sessionTimeout;
            session = jsch.getSession(new String(username), hostname, port);
            if (password != null) {
                session.setPassword(new String(password));
            }
            if ((sessionTimeout = builder.getSessionTimeoutMillis(fileSystemOptions)) != null) {
                session.setTimeout(sessionTimeout.intValue());
            }
            if ((userInfo = builder.getUserInfo(fileSystemOptions)) != null) {
                session.setUserInfo(userInfo);
            }
            Properties config = new Properties();
            String strictHostKeyChecking = builder.getStrictHostKeyChecking(fileSystemOptions);
            if (strictHostKeyChecking != null) {
                config.setProperty("StrictHostKeyChecking", strictHostKeyChecking);
            }
            if ((preferredAuthentications = builder.getPreferredAuthentications(fileSystemOptions)) != null) {
                config.setProperty("PreferredAuthentications", preferredAuthentications);
            }
            if ((compression = builder.getCompression(fileSystemOptions)) != null) {
                config.setProperty("consulting.freiheitsgrade.patched.dependencies.compression.s2c", compression);
                config.setProperty("consulting.freiheitsgrade.patched.dependencies.compression.c2s", compression);
            }
            if ((keyExchangeAlgorithm = builder.getKeyExchangeAlgorithm(fileSystemOptions)) != null) {
                config.setProperty("kex", keyExchangeAlgorithm);
            }
            if ((proxyHost = builder.getProxyHost(fileSystemOptions)) != null) {
                int proxyPort = builder.getProxyPort(fileSystemOptions);
                SftpFileSystemConfigBuilder.ProxyType proxyType = builder.getProxyType(fileSystemOptions);
                String proxyUser = builder.getProxyUser(fileSystemOptions);
                String proxyPassword = builder.getProxyPassword(fileSystemOptions);
                ProxyHTTP proxy = null;
                if (SftpFileSystemConfigBuilder.PROXY_HTTP.equals(proxyType)) {
                    proxy = SftpClientFactory.createProxyHTTP(proxyHost, proxyPort);
                    proxy.setUserPasswd(proxyUser, proxyPassword);
                } else if (SftpFileSystemConfigBuilder.PROXY_SOCKS5.equals(proxyType)) {
                    proxy = SftpClientFactory.createProxySOCKS5(proxyHost, proxyPort);
                    ((ProxySOCKS5)proxy).setUserPasswd(proxyUser, proxyPassword);
                } else if (SftpFileSystemConfigBuilder.PROXY_STREAM.equals(proxyType)) {
                    proxy = SftpClientFactory.createStreamProxy(proxyHost, proxyPort, fileSystemOptions, builder);
                }
                if (proxy != null) {
                    session.setProxy((Proxy)proxy);
                }
            }
            if (config.size() > 0) {
                session.setConfig(config);
            }
            session.setDaemonThread(true);
            session.connect();
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider.sftp/connect.error", (Throwable)exc, hostname);
        }
        return session;
    }

    private static void addIdentities(JSch jsch, File sshDir, IdentityProvider[] identities) throws FileSystemException {
        if (identities != null) {
            for (IdentityProvider info : identities) {
                SftpClientFactory.addIdentity(jsch, info);
            }
        } else {
            File privateKeyFile = new File(sshDir, "id_rsa");
            if (privateKeyFile.isFile() && privateKeyFile.canRead()) {
                SftpClientFactory.addIdentity(jsch, new IdentityInfo(privateKeyFile));
            }
        }
    }

    private static void setConfigRepository(JSch jsch, File sshDir, ConfigRepository configRepository, boolean loadOpenSSHConfig) throws FileSystemException {
        if (configRepository != null) {
            jsch.setConfigRepository(configRepository);
        } else if (loadOpenSSHConfig) {
            try {
                OpenSSHConfig openSSHConfig = OpenSSHConfig.parseFile((String)new File(sshDir, OPENSSH_CONFIG_NAME).getAbsolutePath());
                jsch.setConfigRepository((ConfigRepository)openSSHConfig);
            }
            catch (IOException e) {
                throw new FileSystemException("vfs.provider.sftp/load-openssh-config.error", e);
            }
        }
    }

    private static void addIdentity(JSch jsch, IdentityProvider identity) throws FileSystemException {
        try {
            identity.addIdentity(jsch);
        }
        catch (JSchException e) {
            throw new FileSystemException("vfs.provider.sftp/load-private-key.error", (Object)identity, (Throwable)e);
        }
    }

    private static void setKnownHosts(JSch jsch, File sshDir, File knownHostsFile) throws FileSystemException {
        try {
            if (knownHostsFile != null) {
                jsch.setKnownHosts(knownHostsFile.getAbsolutePath());
            } else {
                knownHostsFile = new File(sshDir, "known_hosts");
                if (knownHostsFile.isFile() && knownHostsFile.canRead()) {
                    jsch.setKnownHosts(knownHostsFile.getAbsolutePath());
                }
            }
        }
        catch (JSchException e) {
            throw new FileSystemException("vfs.provider.sftp/known-hosts.error", (Object)knownHostsFile.getAbsolutePath(), (Throwable)e);
        }
    }

    private static Proxy createStreamProxy(String proxyHost, int proxyPort, FileSystemOptions fileSystemOptions, SftpFileSystemConfigBuilder builder) {
        String proxyUser = builder.getProxyUser(fileSystemOptions);
        String proxyPassword = builder.getProxyPassword(fileSystemOptions);
        FileSystemOptions proxyOptions = builder.getProxyOptions(fileSystemOptions);
        String proxyCommand = builder.getProxyCommand(fileSystemOptions);
        SftpStreamProxy proxy = new SftpStreamProxy(proxyCommand, proxyUser, proxyHost, proxyPort, proxyPassword, proxyOptions);
        return proxy;
    }

    private static ProxySOCKS5 createProxySOCKS5(String proxyHost, int proxyPort) {
        return proxyPort == 0 ? new ProxySOCKS5(proxyHost) : new ProxySOCKS5(proxyHost, proxyPort);
    }

    private static ProxyHTTP createProxyHTTP(String proxyHost, int proxyPort) {
        return proxyPort == 0 ? new ProxyHTTP(proxyHost) : new ProxyHTTP(proxyHost, proxyPort);
    }

    private static File findSshDir() {
        File sshDir;
        String sshDirPath = System.getProperty("vfs.sftp.sshdir");
        if (sshDirPath != null && (sshDir = new File(sshDirPath)).exists()) {
            return sshDir;
        }
        sshDir = new File(System.getProperty("user.home"), SSH_DIR_NAME);
        if (sshDir.exists()) {
            return sshDir;
        }
        if (Os.isFamily(Os.OS_FAMILY_WINDOWS)) {
            String userName = System.getProperty("user.name");
            sshDir = new File("C:\\cygwin\\home\\" + userName + "\\" + SSH_DIR_NAME);
            if (sshDir.exists()) {
                return sshDir;
            }
        }
        return new File("");
    }

    static {
        JSch.setLogger((Logger)new JSchLogger());
    }

    private static class JSchLogger
    implements Logger {
        private JSchLogger() {
        }

        public boolean isEnabled(int level) {
            switch (level) {
                case 4: {
                    return LOG.isFatalEnabled();
                }
                case 3: {
                    return LOG.isErrorEnabled();
                }
                case 2: {
                    return LOG.isDebugEnabled();
                }
                case 0: {
                    return LOG.isDebugEnabled();
                }
                case 1: {
                    return LOG.isInfoEnabled();
                }
            }
            return LOG.isDebugEnabled();
        }

        public void log(int level, String msg) {
            switch (level) {
                case 4: {
                    LOG.fatal(msg);
                    break;
                }
                case 3: {
                    LOG.error(msg);
                    break;
                }
                case 2: {
                    LOG.warn(msg);
                    break;
                }
                case 0: {
                    LOG.debug(msg);
                    break;
                }
                case 1: {
                    LOG.info(msg);
                    break;
                }
                default: {
                    LOG.debug(msg);
                }
            }
        }
    }
}

