/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.sftp;

import consulting.freiheitsgrade.patched.dependencies.com.jcraft.jsch.Session;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.Capability;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileName;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystem;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystemConfigBuilder;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystemException;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystemOptions;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.UserAuthenticationData;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.AbstractOriginatingFileProvider;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.GenericFileName;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.sftp.SftpClientFactory;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.sftp.SftpFileNameParser;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.sftp.SftpFileSystem;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.sftp.SftpFileSystemConfigBuilder;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.util.UserAuthenticatorUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public class SftpFileProvider
extends AbstractOriginatingFileProvider {
    public static final String ATTR_USER_INFO = "UI";
    public static final UserAuthenticationData.Type[] AUTHENTICATOR_TYPES = new UserAuthenticationData.Type[]{UserAuthenticationData.USERNAME, UserAuthenticationData.PASSWORD};
    protected static final Collection<Capability> capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.CREATE, Capability.DELETE, Capability.RENAME, Capability.GET_TYPE, Capability.LIST_CHILDREN, Capability.READ_CONTENT, Capability.URI, Capability.WRITE_CONTENT, Capability.GET_LAST_MODIFIED, Capability.SET_LAST_MODIFIED_FILE, Capability.RANDOM_ACCESS_READ, Capability.APPEND_CONTENT));

    static Session createSession(GenericFileName rootName, FileSystemOptions fileSystemOptions) throws FileSystemException {
        UserAuthenticationData authData = null;
        try {
            authData = UserAuthenticatorUtils.authenticate(fileSystemOptions, AUTHENTICATOR_TYPES);
            Session session = SftpClientFactory.createConnection(rootName.getHostName(), rootName.getPort(), UserAuthenticatorUtils.getData(authData, UserAuthenticationData.USERNAME, UserAuthenticatorUtils.toChar(rootName.getUserName())), UserAuthenticatorUtils.getData(authData, UserAuthenticationData.PASSWORD, UserAuthenticatorUtils.toChar(rootName.getPassword())), fileSystemOptions);
            return session;
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider.sftp/connect.error", (Object)rootName, (Throwable)e);
        }
        finally {
            UserAuthenticatorUtils.cleanup(authData);
        }
    }

    public SftpFileProvider() {
        this.setFileNameParser(SftpFileNameParser.getInstance());
    }

    @Override
    protected FileSystem doCreateFileSystem(FileName name, FileSystemOptions fileSystemOptions) throws FileSystemException {
        return new SftpFileSystem((GenericFileName)name, SftpFileProvider.createSession((GenericFileName)name, fileSystemOptions), fileSystemOptions);
    }

    @Override
    public FileSystemConfigBuilder getConfigBuilder() {
        return SftpFileSystemConfigBuilder.getInstance();
    }

    @Override
    public Collection<Capability> getCapabilities() {
        return capabilities;
    }
}

