/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.temp;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.Capability;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileName;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileObject;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystem;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystemException;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystemOptions;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.AbstractFileProvider;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.UriParser;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.local.DefaultLocalFileProvider;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.local.LocalFileSystem;
import java.io.File;
import java.util.Collection;

public class TemporaryFileProvider
extends AbstractFileProvider
implements Comparable<Object> {
    private File rootFile;

    public TemporaryFileProvider(File rootFile) {
        this();
        this.rootFile = rootFile;
    }

    public TemporaryFileProvider() {
    }

    @Override
    public int compareTo(Object o) {
        int h2;
        int h1 = this.hashCode();
        if (h1 < (h2 = o.hashCode())) {
            return -1;
        }
        if (h1 > h2) {
            return 1;
        }
        return 0;
    }

    @Override
    public synchronized FileObject findFile(FileObject baseFile, String uri, FileSystemOptions properties) throws FileSystemException {
        StringBuilder buffer = new StringBuilder(uri);
        String scheme = UriParser.extractScheme(this.getContext().getFileSystemManager().getSchemes(), uri, buffer);
        UriParser.fixSeparators(buffer);
        UriParser.normalisePath(buffer);
        String path = buffer.toString();
        FileSystem filesystem = this.findFileSystem(this, properties);
        if (filesystem == null) {
            if (this.rootFile == null) {
                this.rootFile = this.getContext().getTemporaryFileStore().allocateFile("tempfs");
            }
            FileName rootName = this.getContext().parseURI(scheme + ":" + "/");
            filesystem = new LocalFileSystem(rootName, this.rootFile.getAbsolutePath(), properties);
            this.addFileSystem(this, filesystem);
        }
        return filesystem.resolveFile(path);
    }

    @Override
    public Collection<Capability> getCapabilities() {
        return DefaultLocalFileProvider.capabilities;
    }
}

