/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.zip;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileName;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystemException;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileType;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.AbstractFileName;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.AbstractFileObject;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.zip.ZipFileSystem;
import java.io.InputStream;
import java.util.HashSet;
import java.util.zip.ZipEntry;

public class ZipFileObject
extends AbstractFileObject<ZipFileSystem> {
    protected ZipEntry entry;
    private final HashSet<String> children = new HashSet();
    private FileType type;

    protected ZipFileObject(AbstractFileName name, ZipEntry entry, ZipFileSystem fs, boolean zipExists) throws FileSystemException {
        super(name, fs);
        this.setZipEntry(entry);
        if (!zipExists) {
            this.type = FileType.IMAGINARY;
        }
    }

    protected void setZipEntry(ZipEntry entry) {
        if (this.entry != null) {
            return;
        }
        this.type = entry == null || entry.isDirectory() ? FileType.FOLDER : FileType.FILE;
        this.entry = entry;
    }

    public void attachChild(FileName childName) {
        this.children.add(childName.getBaseName());
    }

    @Override
    public boolean isWriteable() throws FileSystemException {
        return false;
    }

    @Override
    protected FileType doGetType() {
        return this.type;
    }

    @Override
    protected String[] doListChildren() {
        try {
            if (!this.getType().hasChildren()) {
                return null;
            }
        }
        catch (FileSystemException e) {
            throw new RuntimeException(e);
        }
        return this.children.toArray(new String[this.children.size()]);
    }

    @Override
    protected long doGetContentSize() {
        return this.entry.getSize();
    }

    @Override
    protected long doGetLastModifiedTime() throws Exception {
        return this.entry.getTime();
    }

    @Override
    protected InputStream doGetInputStream(int bufferSize) throws Exception {
        if (!this.getType().hasContent()) {
            throw new FileSystemException("vfs.provider/read-not-file.error", (Object)this.getName());
        }
        return ((ZipFileSystem)this.getAbstractFileSystem()).getZipFile().getInputStream(this.entry);
    }

    @Override
    protected void doAttach() throws Exception {
        ((ZipFileSystem)this.getAbstractFileSystem()).getZipFile();
    }

    @Override
    protected void doDetach() throws Exception {
        ZipFileSystem afs = (ZipFileSystem)this.getAbstractFileSystem();
        if (!afs.isOpen()) {
            afs.close();
        }
    }
}

