/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.zip;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.Capability;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileObject;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystem;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystemConfigBuilder;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystemException;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystemOptions;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileType;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.AbstractLayeredFileProvider;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.LayeredFileName;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.zip.ZipFileSystem;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.zip.ZipFileSystemConfigBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public class ZipFileProvider
extends AbstractLayeredFileProvider {
    protected static final Collection<Capability> capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.GET_LAST_MODIFIED, Capability.GET_TYPE, Capability.LIST_CHILDREN, Capability.READ_CONTENT, Capability.URI, Capability.COMPRESS, Capability.VIRTUAL));

    @Override
    protected FileSystem doCreateFileSystem(String scheme, FileObject file, FileSystemOptions fileSystemOptions) throws FileSystemException {
        LayeredFileName rootName = new LayeredFileName(scheme, file.getName(), "/", FileType.FOLDER);
        return new ZipFileSystem(rootName, file, fileSystemOptions);
    }

    @Override
    public Collection<Capability> getCapabilities() {
        return capabilities;
    }

    @Override
    public FileSystemConfigBuilder getConfigBuilder() {
        return ZipFileSystemConfigBuilder.getInstance();
    }
}

