/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.tasks;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileObject;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.tasks.VfsTask;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.util.Messages;
import consulting.freiheitsgrade.patched.dependencies.org.apache.tools.ant.BuildException;
import java.util.StringTokenizer;

public class DeleteTask
extends VfsTask {
    private String file;
    private String srcDirUrl;
    private String filesList;

    public void setFile(String file) {
        this.file = file;
    }

    public void setSrcDir(String srcDir) {
        this.srcDirUrl = srcDir;
    }

    public void setIncludes(String filesList) {
        this.filesList = filesList;
    }

    public void execute() throws BuildException {
        if (this.file == null && this.srcDirUrl == null || this.srcDirUrl != null && this.filesList == null) {
            String message = Messages.getString("vfs.tasks/delete.no-source-files.error");
            throw new BuildException(message);
        }
        try {
            if (this.srcDirUrl != null && this.filesList != null) {
                this.log("Deleting " + this.filesList + " in the directory " + this.srcDirUrl);
                if (!this.srcDirUrl.endsWith("/")) {
                    this.srcDirUrl = this.srcDirUrl + "/";
                }
                StringTokenizer tok = new StringTokenizer(this.filesList, ", \t\n\r\f", false);
                while (tok.hasMoreTokens()) {
                    String nextFile = tok.nextToken();
                    FileObject srcFile = this.resolveFile(this.srcDirUrl + nextFile);
                    srcFile.deleteAll();
                }
            } else {
                FileObject srcFile = this.resolveFile(this.file);
                this.log("Deleting " + srcFile.getPublicURIString());
                srcFile.deleteAll();
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }
}

