/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.tasks;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileContent;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileObject;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.tasks.VfsTask;
import consulting.freiheitsgrade.patched.dependencies.org.apache.tools.ant.BuildException;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Date;

public class ShowFileTask
extends VfsTask {
    private static final String INDENT = "  ";
    private String url;
    private boolean showContent;
    private boolean recursive;

    public void setFile(String url) {
        this.url = url;
    }

    public void setShowContent(boolean showContent) {
        this.showContent = showContent;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public void execute() throws BuildException {
        try (FileObject file = this.resolveFile(this.url);){
            this.log("Details of " + file.getPublicURIString());
            this.showFile(file, INDENT);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void showFile(FileObject file, String prefix) throws Exception {
        StringBuilder msg = new StringBuilder(prefix);
        msg.append(file.getName().getBaseName());
        if (file.exists()) {
            msg.append(" (");
            msg.append(file.getType().getName());
            msg.append(")");
        } else {
            msg.append(" (unknown)");
        }
        this.log(msg.toString());
        if (file.exists()) {
            String newPrefix = prefix + INDENT;
            if (file.getType().hasContent()) {
                FileContent content = file.getContent();
                Object object = null;
                try {
                    this.log(newPrefix + "Content-Length: " + content.getSize());
                    this.log(newPrefix + "Last-Modified" + new Date(content.getLastModifiedTime()));
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (content != null) {
                        if (object != null) {
                            try {
                                content.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            content.close();
                        }
                    }
                }
                if (this.showContent) {
                    this.log(newPrefix + "Content:");
                    this.logContent(file, newPrefix);
                }
            }
            if (file.getType().hasChildren()) {
                FileObject[] children = file.getChildren();
                for (FileObject child : children) {
                    if (this.recursive) {
                        this.showFile(child, newPrefix);
                        continue;
                    }
                    this.log(newPrefix + child.getName().getBaseName());
                }
            }
        }
    }

    private void logContent(FileObject file, String prefix) throws Exception {
        try (InputStream instr = file.getContent().getInputStream();
             BufferedReader reader = new BufferedReader(new InputStreamReader(instr));){
            String line;
            while ((line = reader.readLine()) != null) {
                this.log(prefix + line);
            }
        }
    }
}

