/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.util;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileContent;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileObject;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.FileSystemException;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.impl.DecoratedFileObject;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.provider.AbstractFileObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Properties;

public final class FileObjectUtils {
    public static boolean exists(FileObject fileObject) throws FileSystemException {
        return fileObject != null && fileObject.exists();
    }

    public static AbstractFileObject getAbstractFileObject(FileObject fileObject) throws FileSystemException {
        FileObject searchObject = fileObject;
        while (searchObject instanceof DecoratedFileObject) {
            searchObject = ((DecoratedFileObject)searchObject).getDecoratedFileObject();
        }
        if (searchObject instanceof AbstractFileObject) {
            return (AbstractFileObject)searchObject;
        }
        if (searchObject == null) {
            return null;
        }
        throw new FileSystemException("vfs.util/find-abstract-file-object.error", (Object)(fileObject == null ? "null" : fileObject.getClass().getName()));
    }

    public static byte[] getContentAsByteArray(FileObject file) throws IOException {
        try (FileContent content = file.getContent();){
            byte[] byArray = content.getByteArray();
            return byArray;
        }
    }

    public static String getContentAsString(FileObject file, Charset charset) throws IOException {
        try (FileContent content = file.getContent();){
            String string = content.getString(charset);
            return string;
        }
    }

    public static String getContentAsString(FileObject file, String charset) throws IOException {
        try (FileContent content = file.getContent();){
            String string = content.getString(charset);
            return string;
        }
    }

    public static boolean isInstanceOf(FileObject fileObject, Class<?> wantedClass) throws FileSystemException {
        FileObject searchObject = fileObject;
        while (searchObject instanceof DecoratedFileObject) {
            if (wantedClass.isInstance(searchObject)) {
                return true;
            }
            searchObject = ((DecoratedFileObject)searchObject).getDecoratedFileObject();
        }
        return wantedClass.isInstance(searchObject);
    }

    public static Properties readProperties(FileObject fileObject) throws FileSystemException, IOException {
        return FileObjectUtils.readProperties(fileObject, new Properties());
    }

    public static Properties readProperties(FileObject fileObject, Properties properties) throws FileSystemException, IOException {
        if (fileObject == null) {
            return properties;
        }
        try (InputStream inputStream = fileObject.getContent().getInputStream();){
            properties.load(inputStream);
        }
        return properties;
    }

    public static void writeContent(FileObject file, OutputStream output) throws IOException {
        try (FileContent content = file.getContent();){
            content.write(output);
        }
    }

    public static void writeContent(FileObject srcFile, FileObject destFile) throws IOException {
        try (FileContent content = srcFile.getContent();){
            content.write(destFile);
        }
    }

    private FileObjectUtils() {
    }
}

