/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.util;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.util.OsFamily;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;

public final class Os {
    public static final OsFamily OS_FAMILY_WINDOWS = new OsFamily("windows");
    public static final OsFamily OS_FAMILY_DOS = new OsFamily("dos");
    public static final OsFamily OS_FAMILY_WINNT = new OsFamily("nt", new OsFamily[]{OS_FAMILY_WINDOWS});
    public static final OsFamily OS_FAMILY_WIN9X = new OsFamily("win9x", new OsFamily[]{OS_FAMILY_WINDOWS, OS_FAMILY_DOS});
    public static final OsFamily OS_FAMILY_OS2 = new OsFamily("os/2", new OsFamily[]{OS_FAMILY_DOS});
    public static final OsFamily OS_FAMILY_NETWARE = new OsFamily("netware");
    public static final OsFamily OS_FAMILY_UNIX = new OsFamily("unix");
    public static final OsFamily OS_FAMILY_MAC = new OsFamily("mac");
    public static final OsFamily OS_FAMILY_OSX = new OsFamily("osx", new OsFamily[]{OS_FAMILY_UNIX, OS_FAMILY_MAC});
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
    private static final String OS_ARCH = System.getProperty("os.arch").toLowerCase(Locale.US);
    private static final String OS_VERSION = System.getProperty("os.version").toLowerCase(Locale.US);
    private static final String PATH_SEP = File.pathSeparator;
    private static final OsFamily OS_FAMILY;
    private static final OsFamily[] OS_ALL_FAMILIES;
    private static final OsFamily[] ALL_FAMILIES;

    private Os() {
    }

    public static boolean isVersion(String version) {
        return Os.isOs((OsFamily)null, null, null, version);
    }

    public static boolean isArch(String arch) {
        return Os.isOs((OsFamily)null, null, arch, null);
    }

    public static boolean isFamily(String family) {
        return Os.isOs(family, null, null, null);
    }

    public static boolean isFamily(OsFamily family) {
        return Os.isOs(family, null, null, null);
    }

    public static boolean isName(String name) {
        return Os.isOs((OsFamily)null, name, null, null);
    }

    public static boolean isOs(String family, String name, String arch, String version) {
        return Os.isOs(Os.getFamily(family), name, arch, version);
    }

    public static boolean isOs(OsFamily family, String name, String arch, String version) {
        if (family != null || name != null || arch != null || version != null) {
            boolean isFamily = Os.familyMatches(family);
            boolean isName = Os.nameMatches(name);
            boolean isArch = Os.archMatches(arch);
            boolean isVersion = Os.versionMatches(version);
            return isFamily && isName && isArch && isVersion;
        }
        return false;
    }

    public static OsFamily getFamily(String name) {
        for (OsFamily osFamily : ALL_FAMILIES) {
            if (!osFamily.getName().equalsIgnoreCase(name)) continue;
            return osFamily;
        }
        return null;
    }

    private static boolean versionMatches(String version) {
        boolean isVersion = true;
        if (version != null) {
            isVersion = version.equalsIgnoreCase(OS_VERSION);
        }
        return isVersion;
    }

    private static boolean archMatches(String arch) {
        boolean isArch = true;
        if (arch != null) {
            isArch = arch.equalsIgnoreCase(OS_ARCH);
        }
        return isArch;
    }

    private static boolean nameMatches(String name) {
        boolean isName = true;
        if (name != null) {
            isName = name.equalsIgnoreCase(OS_NAME);
        }
        return isName;
    }

    private static boolean familyMatches(OsFamily family) {
        if (family == null) {
            return false;
        }
        for (OsFamily osFamily : OS_ALL_FAMILIES) {
            if (family != osFamily) continue;
            return true;
        }
        return false;
    }

    private static OsFamily[] determineAllFamilies() {
        HashSet<OsFamily> allFamilies = new HashSet<OsFamily>();
        if (OS_FAMILY != null) {
            ArrayList<OsFamily> queue = new ArrayList<OsFamily>();
            queue.add(OS_FAMILY);
            while (queue.size() > 0) {
                OsFamily[] families;
                OsFamily family = (OsFamily)queue.remove(0);
                allFamilies.add(family);
                for (OsFamily parent : families = family.getFamilies()) {
                    queue.add(parent);
                }
            }
        }
        return allFamilies.toArray(new OsFamily[allFamilies.size()]);
    }

    private static OsFamily determineOsFamily() {
        if (OS_NAME.indexOf("windows") > -1) {
            if (OS_NAME.indexOf("xp") > -1 || OS_NAME.indexOf("2000") > -1 || OS_NAME.indexOf("nt") > -1) {
                return OS_FAMILY_WINNT;
            }
            return OS_FAMILY_WIN9X;
        }
        if (OS_NAME.indexOf("os/2") > -1) {
            return OS_FAMILY_OS2;
        }
        if (OS_NAME.indexOf("netware") > -1) {
            return OS_FAMILY_NETWARE;
        }
        if (OS_NAME.indexOf("mac") > -1) {
            if (OS_NAME.endsWith("x")) {
                return OS_FAMILY_OSX;
            }
            return OS_FAMILY_MAC;
        }
        if (PATH_SEP.equals(":")) {
            return OS_FAMILY_UNIX;
        }
        return null;
    }

    static {
        ALL_FAMILIES = new OsFamily[]{OS_FAMILY_DOS, OS_FAMILY_MAC, OS_FAMILY_NETWARE, OS_FAMILY_OS2, OS_FAMILY_OSX, OS_FAMILY_UNIX, OS_FAMILY_WINDOWS, OS_FAMILY_WINNT, OS_FAMILY_WIN9X};
        OS_FAMILY = Os.determineOsFamily();
        OS_ALL_FAMILIES = Os.determineAllFamilies();
    }
}

