/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.util;

import java.util.EnumMap;
import java.util.Map;

public class PosixPermissions {
    private final int permissions;
    private final boolean isOwner;
    private final boolean isInGroup;

    public PosixPermissions(int permissions, boolean isOwner, boolean isInGroup) {
        this.permissions = permissions;
        this.isOwner = isOwner;
        this.isInGroup = isInGroup;
    }

    private int computeNewPermissions(Map<Type, Boolean> values) {
        int newPerms = this.permissions;
        for (Map.Entry<Type, Boolean> entry : values.entrySet()) {
            Type type = entry.getKey();
            if (entry.getValue().booleanValue()) {
                newPerms |= type.getMask();
                continue;
            }
            newPerms &= ~type.getMask();
        }
        return newPerms;
    }

    private boolean get(Type type) {
        return (type.getMask() & this.permissions) != 0;
    }

    public int getPermissions() {
        return this.permissions;
    }

    public boolean isExecutable() {
        if (this.isOwner) {
            return this.get(Type.UserExecutable);
        }
        if (this.isInGroup) {
            return this.get(Type.GroupExecutable);
        }
        return this.get(Type.OtherExecutable);
    }

    public boolean isReadable() {
        if (this.isOwner) {
            return this.get(Type.UserReadable);
        }
        if (this.isInGroup) {
            return this.get(Type.GroupReadable);
        }
        return this.get(Type.OtherReadable);
    }

    public boolean isWritable() {
        if (this.isOwner) {
            return this.get(Type.UserWritable);
        }
        if (this.isInGroup) {
            return this.get(Type.GroupWritable);
        }
        return this.get(Type.OtherWritable);
    }

    public int makeExecutable(boolean executable, boolean ownerOnly) {
        EnumMap<Type, Boolean> map = new EnumMap<Type, Boolean>(Type.class);
        map.put(Type.UserExecutable, executable);
        if (!ownerOnly) {
            map.put(Type.GroupExecutable, executable);
            map.put(Type.OtherExecutable, executable);
        }
        return this.computeNewPermissions(map);
    }

    public Integer makeReadable(boolean readable, boolean ownerOnly) {
        EnumMap<Type, Boolean> map = new EnumMap<Type, Boolean>(Type.class);
        map.put(Type.UserReadable, readable);
        if (!ownerOnly) {
            map.put(Type.GroupReadable, readable);
            map.put(Type.OtherReadable, readable);
        }
        return this.computeNewPermissions(map);
    }

    public Integer makeWritable(boolean writable, boolean ownerOnly) {
        EnumMap<Type, Boolean> map = new EnumMap<Type, Boolean>(Type.class);
        map.put(Type.UserWritable, writable);
        if (!ownerOnly) {
            map.put(Type.GroupWritable, writable);
            map.put(Type.OtherWritable, writable);
        }
        return this.computeNewPermissions(map);
    }

    public static enum Type {
        UserReadable(256),
        UserWritable(128),
        UserExecutable(64),
        GroupReadable(32),
        GroupWritable(16),
        GroupExecutable(8),
        OtherReadable(4),
        OtherWritable(2),
        OtherExecutable(1);

        private final int mask;

        private Type(int mask) {
            this.mask = mask;
        }

        public int getMask() {
            return this.mask;
        }
    }
}

