/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.util;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.logging.Log;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.logging.LogFactory;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.vfs2.util.URIBitSets;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.util.BitSet;

public class URIUtils {
    private static final Log LOG = LogFactory.getLog(URIUtils.class);
    private static final String DEFAULT_PROTOCOL_CHARSET = "UTF-8";

    private URIUtils() {
    }

    public static String encodePath(String unescaped) throws URISyntaxException {
        return URIUtils.encodePath(unescaped, DEFAULT_PROTOCOL_CHARSET);
    }

    public static String encodePath(String unescaped, String charset) throws URISyntaxException {
        if (unescaped == null) {
            throw new IllegalArgumentException("The string to encode may not be null.");
        }
        return URIUtils.encode(unescaped, URIBitSets.allowed_abs_path, charset);
    }

    private static String encode(String unescaped, BitSet allowed, String charset) throws URISyntaxException {
        byte[] rawdata = URLCodecUtils.encodeUrl(allowed, EncodingUtils.getBytes(unescaped, charset));
        return EncodingUtils.getAsciiString(rawdata, 0, rawdata.length);
    }

    private static class EncodingUtils {
        private EncodingUtils() {
        }

        static byte[] getBytes(String data, String charset) {
            if (data == null) {
                throw new IllegalArgumentException("data may not be null");
            }
            if (charset == null || charset.length() == 0) {
                throw new IllegalArgumentException("charset may not be null or empty");
            }
            try {
                return data.getBytes(charset);
            }
            catch (UnsupportedEncodingException e) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Unsupported encoding: " + charset + ". System encoding used.");
                }
                return data.getBytes();
            }
        }

        static String getAsciiString(byte[] data, int offset, int length) {
            try {
                return new String(data, offset, length, "US-ASCII");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("US-ASCII charset is not supported.");
            }
        }
    }

    private static class URLCodecUtils {
        private static final byte ESCAPE_CHAR = 37;
        private static final BitSet WWW_FORM_URL_SAFE;
        private static final int RADIX = 16;

        private URLCodecUtils() {
        }

        static final byte[] encodeUrl(BitSet urlsafe, byte[] bytes) {
            if (bytes == null) {
                return null;
            }
            if (urlsafe == null) {
                urlsafe = WWW_FORM_URL_SAFE;
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            for (int n : bytes) {
                int b = n;
                if (b < 0) {
                    b = 256 + b;
                }
                if (urlsafe.get(b)) {
                    if (b == 32) {
                        b = 43;
                    }
                    buffer.write(b);
                    continue;
                }
                buffer.write(37);
                char hex1 = URLCodecUtils.hexDigit(b >> 4);
                char hex2 = URLCodecUtils.hexDigit(b);
                buffer.write(hex1);
                buffer.write(hex2);
            }
            return buffer.toByteArray();
        }

        private static char hexDigit(int b) {
            return Character.toUpperCase(Character.forDigit(b & 0xF, 16));
        }

        static {
            int i;
            WWW_FORM_URL_SAFE = new BitSet(256);
            for (i = 97; i <= 122; ++i) {
                WWW_FORM_URL_SAFE.set(i);
            }
            for (i = 65; i <= 90; ++i) {
                WWW_FORM_URL_SAFE.set(i);
            }
            for (i = 48; i <= 57; ++i) {
                WWW_FORM_URL_SAFE.set(i);
            }
            WWW_FORM_URL_SAFE.set(45);
            WWW_FORM_URL_SAFE.set(95);
            WWW_FORM_URL_SAFE.set(46);
            WWW_FORM_URL_SAFE.set(42);
            WWW_FORM_URL_SAFE.set(32);
        }
    }
}

