/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs;

import consulting.freiheitsgrade.patched.dependencies.com.google.common.annotations.VisibleForTesting;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.classification.InterfaceAudience;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.conf.Configuration;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.DFSUtilClient;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.KeyProviderCache;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.PeerCache;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.client.impl.DfsClientConf;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.shortcircuit.DomainSocketFactory;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.shortcircuit.ShortCircuitCache;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.util.ByteArrayManager;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.net.DNSToSwitchMapping;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.net.NetUtils;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.net.NetworkTopology;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.net.Node;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.net.NodeBase;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.net.ScriptBasedMapping;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.util.ReflectionUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ClientContext {
    private static final Logger LOG = LoggerFactory.getLogger(ClientContext.class);
    private static final HashMap<String, ClientContext> CACHES = new HashMap();
    private final String name;
    private final String confString;
    private final ShortCircuitCache shortCircuitCache;
    private final PeerCache peerCache;
    private final DomainSocketFactory domainSocketFactory;
    private final KeyProviderCache keyProviderCache;
    private final boolean useLegacyBlockReaderLocal;
    private volatile boolean disableLegacyBlockReaderLocal = false;
    private final ByteArrayManager byteArrayManager;
    private boolean printedConfWarning = false;
    private NodeBase clientNode;
    private boolean topologyResolutionEnabled;

    private ClientContext(String name, DfsClientConf conf, Configuration config) {
        DfsClientConf.ShortCircuitConf scConf = conf.getShortCircuitConf();
        this.name = name;
        this.confString = scConf.confAsString();
        this.shortCircuitCache = ShortCircuitCache.fromConf(scConf);
        this.peerCache = new PeerCache(scConf.getSocketCacheCapacity(), scConf.getSocketCacheExpiry());
        this.keyProviderCache = new KeyProviderCache(scConf.getKeyProviderCacheExpiryMs());
        this.useLegacyBlockReaderLocal = scConf.isUseLegacyBlockReaderLocal();
        this.domainSocketFactory = new DomainSocketFactory(scConf);
        this.byteArrayManager = ByteArrayManager.newInstance(conf.getWriteByteArrayManagerConf());
        this.initTopologyResolution(config);
    }

    private void initTopologyResolution(Configuration config) {
        this.topologyResolutionEnabled = config.getBoolean("fs.client.resolve.topology.enabled", false);
        if (!this.topologyResolutionEnabled) {
            return;
        }
        DNSToSwitchMapping dnsToSwitchMapping = (DNSToSwitchMapping)ReflectionUtils.newInstance((Class)config.getClass("net.topology.node.switch.mapping.impl", ScriptBasedMapping.class, DNSToSwitchMapping.class), (Configuration)config);
        String clientHostName = NetUtils.getLocalHostname();
        ArrayList<String> nodes = new ArrayList<String>();
        nodes.add(clientHostName);
        List resolvedHosts = dnsToSwitchMapping.resolve(nodes);
        if (resolvedHosts != null && !resolvedHosts.isEmpty() && !((String)resolvedHosts.get(0)).equals("/default-rack")) {
            this.clientNode = new NodeBase(clientHostName, (String)resolvedHosts.get(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClientContext get(String name, DfsClientConf conf, Configuration config) {
        Class<ClientContext> clazz = ClientContext.class;
        synchronized (ClientContext.class) {
            ClientContext context = CACHES.get(name);
            if (context == null) {
                context = new ClientContext(name, conf, config);
                CACHES.put(name, context);
            } else {
                context.printConfWarningIfNeeded(conf);
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return context;
        }
    }

    public static ClientContext get(String name, Configuration config) {
        return ClientContext.get(name, new DfsClientConf(config), config);
    }

    @VisibleForTesting
    public static ClientContext getFromConf(Configuration conf) {
        return ClientContext.get(conf.get("dfs.client.context", "default"), conf);
    }

    private void printConfWarningIfNeeded(DfsClientConf conf) {
        String requested;
        String existing = this.getConfString();
        if (!existing.equals(requested = conf.getShortCircuitConf().confAsString()) && !this.printedConfWarning) {
            this.printedConfWarning = true;
            LOG.warn("Existing client context '" + this.name + "' does not match requested configuration.  Existing: " + existing + ", Requested: " + requested);
        }
    }

    public String getConfString() {
        return this.confString;
    }

    public ShortCircuitCache getShortCircuitCache() {
        return this.shortCircuitCache;
    }

    public PeerCache getPeerCache() {
        return this.peerCache;
    }

    public KeyProviderCache getKeyProviderCache() {
        return this.keyProviderCache;
    }

    public boolean getUseLegacyBlockReaderLocal() {
        return this.useLegacyBlockReaderLocal;
    }

    public boolean getDisableLegacyBlockReaderLocal() {
        return this.disableLegacyBlockReaderLocal;
    }

    public void setDisableLegacyBlockReaderLocal() {
        this.disableLegacyBlockReaderLocal = true;
    }

    public DomainSocketFactory getDomainSocketFactory() {
        return this.domainSocketFactory;
    }

    public ByteArrayManager getByteArrayManager() {
        return this.byteArrayManager;
    }

    public int getNetworkDistance(DatanodeInfo datanodeInfo) throws IOException {
        if (this.clientNode == null) {
            return DFSUtilClient.isLocalAddress(NetUtils.createSocketAddr((String)datanodeInfo.getXferAddr())) ? 0 : Integer.MAX_VALUE;
        }
        NodeBase node = new NodeBase(datanodeInfo.getHostName(), datanodeInfo.getNetworkLocation());
        return NetworkTopology.getDistanceByPath((Node)this.clientNode, (Node)node);
    }
}

