/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs;

import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.classification.InterfaceAudience;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.classification.InterfaceStability;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.ipc.AlignmentContext;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.ipc.protobuf.RpcHeaderProtos;
import java.io.IOException;
import java.util.concurrent.atomic.LongAccumulator;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ClientGSIContext
implements AlignmentContext {
    private final LongAccumulator lastSeenStateId = new LongAccumulator(Math::max, Long.MIN_VALUE);

    public long getLastSeenStateId() {
        return this.lastSeenStateId.get();
    }

    public boolean isCoordinatedCall(String protocolName, String method) {
        throw new UnsupportedOperationException("Client should not be checking uncoordinated call");
    }

    public void updateResponseState(RpcHeaderProtos.RpcResponseHeaderProto.Builder header) {
    }

    public void receiveResponseState(RpcHeaderProtos.RpcResponseHeaderProto header) {
        this.lastSeenStateId.accumulate(header.getStateId());
    }

    public void updateRequestState(RpcHeaderProtos.RpcRequestHeaderProto.Builder header) {
        header.setStateId(this.lastSeenStateId.longValue());
    }

    public long receiveRequestState(RpcHeaderProtos.RpcRequestHeaderProto header, long threshold) throws IOException {
        return 0L;
    }
}

