/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs;

import consulting.freiheitsgrade.patched.dependencies.com.google.common.annotations.VisibleForTesting;
import consulting.freiheitsgrade.patched.dependencies.com.google.common.base.Preconditions;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.collections.list.TreeList;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.HadoopIllegalArgumentException;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.classification.InterfaceAudience;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.classification.InterfaceStability;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.conf.Configuration;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.crypto.key.KeyProvider;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.crypto.key.KeyProviderTokenIssuer;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.fs.BlockLocation;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.fs.BlockStoragePolicySpi;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.fs.CacheFlag;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.fs.ContentSummary;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.fs.CreateFlag;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.fs.FSDataInputStream;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.fs.FSDataOutputStream;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.fs.FSDataOutputStreamBuilder;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.fs.FSLinkResolver;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.fs.FileAlreadyExistsException;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.fs.FileChecksum;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.fs.FileEncryptionInfo;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.fs.FileStatus;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.fs.FileSystem;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.fs.FileSystemLinkResolver;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.fs.FsServerDefaults;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.fs.FsStatus;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.fs.GlobalStorageStatistics;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.fs.LocatedFileStatus;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.fs.Options;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.fs.Path;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.fs.PathFilter;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.fs.PathHandle;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.fs.QuotaUsage;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.fs.RemoteIterator;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.fs.StorageStatistics;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.fs.StorageType;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.fs.UnresolvedLinkException;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.fs.UnsupportedFileSystemException;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.fs.XAttrSetFlag;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.fs.permission.AclEntry;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.fs.permission.AclStatus;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.fs.permission.FsAction;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.fs.permission.FsPermission;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.DFSClient;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.DFSHedgedReadMetrics;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.DFSInotifyEventInputStream;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.DFSInputStream;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.DFSOpsCountStatistics;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.DFSOutputStream;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.DFSUtilClient;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.HAUtilClient;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.HdfsConfiguration;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.client.impl.CorruptFileBlockIterator;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.client.impl.SnapshotDiffReportGenerator;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol.AddErasureCodingPolicyResponse;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol.DirectoryListing;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol.EncryptionZone;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol.ErasureCodingPolicyInfo;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol.HdfsConstants;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol.HdfsLocatedFileStatus;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol.HdfsPathHandle;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol.OpenFileEntry;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol.OpenFilesIterator;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol.RollingUpgradeInfo;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol.SnapshotDiffReportListing;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol.ZoneReencryptionStatus;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.io.Text;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.net.NetUtils;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.security.token.DelegationTokenIssuer;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.security.token.Token;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.util.ChunkedArrayList;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.util.Progressable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import javax.annotation.Nonnull;

@InterfaceAudience.LimitedPrivate(value={"MapReduce", "HBase"})
@InterfaceStability.Unstable
public class DistributedFileSystem
extends FileSystem
implements KeyProviderTokenIssuer {
    private Path workingDir;
    private URI uri;
    DFSClient dfs;
    private boolean verifyChecksum = true;
    private DFSOpsCountStatistics storageStatistics;

    public String getScheme() {
        return "hdfs";
    }

    public URI getUri() {
        return this.uri;
    }

    public void initialize(URI uri, Configuration conf) throws IOException {
        super.initialize(uri, conf);
        this.setConf(conf);
        String host = uri.getHost();
        if (host == null) {
            throw new IOException("Incomplete HDFS URI, no host: " + uri);
        }
        this.dfs = new DFSClient(uri, conf, this.statistics);
        this.uri = URI.create(uri.getScheme() + "://" + uri.getAuthority());
        this.workingDir = this.getHomeDirectory();
        this.storageStatistics = (DFSOpsCountStatistics)GlobalStorageStatistics.INSTANCE.put("DFSOpsCountStatistics", new GlobalStorageStatistics.StorageStatisticsProvider(){

            public StorageStatistics provide() {
                return new DFSOpsCountStatistics();
            }
        });
    }

    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    public long getDefaultBlockSize() {
        return this.dfs.getConf().getDefaultBlockSize();
    }

    public short getDefaultReplication() {
        return this.dfs.getConf().getDefaultReplication();
    }

    public void setWorkingDirectory(Path dir) {
        String result = this.fixRelativePart(dir).toUri().getPath();
        if (!DFSUtilClient.isValidName(result)) {
            throw new IllegalArgumentException("Invalid DFS directory name " + result);
        }
        this.workingDir = this.fixRelativePart(dir);
    }

    public Path getHomeDirectory() {
        return this.makeQualified(DFSUtilClient.getHomeDirectory(this.getConf(), this.dfs.ugi));
    }

    public DFSHedgedReadMetrics getHedgedReadMetrics() {
        return this.dfs.getHedgedReadMetrics();
    }

    String getPathName(Path file) {
        this.checkPath(file);
        String result = file.toUri().getPath();
        if (!DFSUtilClient.isValidName(result)) {
            throw new IllegalArgumentException("Pathname " + result + " from " + file + " is not a valid DFS filename.");
        }
        return result;
    }

    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        if (file == null) {
            return null;
        }
        return this.getFileBlockLocations(file.getPath(), start, len);
    }

    public BlockLocation[] getFileBlockLocations(Path p, final long start, final long len) throws IOException {
        this.statistics.incrementReadOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.GET_FILE_BLOCK_LOCATIONS);
        Path absF = this.fixRelativePart(p);
        return (BlockLocation[])new FileSystemLinkResolver<BlockLocation[]>(){

            public BlockLocation[] doCall(Path p) throws IOException {
                return DistributedFileSystem.this.dfs.getBlockLocations(DistributedFileSystem.this.getPathName(p), start, len);
            }

            public BlockLocation[] next(FileSystem fs, Path p) throws IOException {
                return fs.getFileBlockLocations(p, start, len);
            }
        }.resolve((FileSystem)this, absF);
    }

    public void setVerifyChecksum(boolean verifyChecksum) {
        this.verifyChecksum = verifyChecksum;
    }

    public boolean recoverLease(final Path f) throws IOException {
        Path absF = this.fixRelativePart(f);
        return (Boolean)new FileSystemLinkResolver<Boolean>(){

            public Boolean doCall(Path p) throws IOException {
                return DistributedFileSystem.this.dfs.recoverLease(DistributedFileSystem.this.getPathName(p));
            }

            public Boolean next(FileSystem fs, Path p) throws IOException {
                if (fs instanceof DistributedFileSystem) {
                    DistributedFileSystem myDfs = (DistributedFileSystem)fs;
                    return myDfs.recoverLease(p);
                }
                throw new UnsupportedOperationException("Cannot recoverLease through a symlink to a non-DistributedFileSystem: " + f + " -> " + p);
            }
        }.resolve((FileSystem)this, absF);
    }

    public FSDataInputStream open(Path f, final int bufferSize) throws IOException {
        this.statistics.incrementReadOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.OPEN);
        Path absF = this.fixRelativePart(f);
        return (FSDataInputStream)new FileSystemLinkResolver<FSDataInputStream>(){

            public FSDataInputStream doCall(Path p) throws IOException {
                DFSInputStream dfsis = DistributedFileSystem.this.dfs.open(DistributedFileSystem.this.getPathName(p), bufferSize, DistributedFileSystem.this.verifyChecksum);
                return DistributedFileSystem.this.dfs.createWrappedInputStream(dfsis);
            }

            public FSDataInputStream next(FileSystem fs, Path p) throws IOException {
                return fs.open(p, bufferSize);
            }
        }.resolve((FileSystem)this, absF);
    }

    public FSDataInputStream open(PathHandle fd, int bufferSize) throws IOException {
        this.statistics.incrementReadOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.OPEN);
        if (!(fd instanceof HdfsPathHandle)) {
            fd = new HdfsPathHandle(fd.bytes());
        }
        HdfsPathHandle id = (HdfsPathHandle)fd;
        DFSInputStream dfsis = this.dfs.open(id, bufferSize, this.verifyChecksum);
        return this.dfs.createWrappedInputStream(dfsis);
    }

    protected HdfsPathHandle createPathHandle(FileStatus st, Options.HandleOpt ... opts) {
        Optional<Long> inodeId;
        Path p;
        if (!(st instanceof HdfsFileStatus)) {
            throw new IllegalArgumentException("Invalid FileStatus " + st.getClass().getSimpleName());
        }
        if (st.isDirectory() || st.isSymlink()) {
            throw new IllegalArgumentException("PathHandle only available for files");
        }
        if (!this.getUri().getAuthority().equals(st.getPath().toUri().getAuthority())) {
            throw new IllegalArgumentException("Wrong FileSystem: " + st.getPath());
        }
        Options.HandleOpt.Data data = Options.HandleOpt.getOpt(Options.HandleOpt.Data.class, (Options.HandleOpt[])opts).orElse(Options.HandleOpt.changed((boolean)false));
        Options.HandleOpt.Location loc = Options.HandleOpt.getOpt(Options.HandleOpt.Location.class, (Options.HandleOpt[])opts).orElse(Options.HandleOpt.moved((boolean)false));
        HdfsFileStatus hst = (HdfsFileStatus)st;
        if (loc.allowChange()) {
            p = DFSUtilClient.makePathFromFileId(hst.getFileId());
            inodeId = Optional.empty();
        } else {
            p = hst.getPath();
            inodeId = Optional.of(hst.getFileId());
        }
        Optional<Long> mtime = !data.allowChange() ? Optional.of(hst.getModificationTime()) : Optional.empty();
        return new HdfsPathHandle(this.getPathName(p), inodeId, mtime);
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        return this.append(f, EnumSet.of(CreateFlag.APPEND), bufferSize, progress);
    }

    public FSDataOutputStream append(Path f, final EnumSet<CreateFlag> flag, final int bufferSize, final Progressable progress) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.APPEND);
        Path absF = this.fixRelativePart(f);
        return (FSDataOutputStream)new FileSystemLinkResolver<FSDataOutputStream>(){

            public FSDataOutputStream doCall(Path p) throws IOException {
                return DistributedFileSystem.this.dfs.append(DistributedFileSystem.this.getPathName(p), bufferSize, (EnumSet<CreateFlag>)flag, progress, DistributedFileSystem.this.statistics);
            }

            public FSDataOutputStream next(FileSystem fs, Path p) throws IOException {
                return fs.append(p, bufferSize);
            }
        }.resolve((FileSystem)this, absF);
    }

    public FSDataOutputStream append(Path f, final EnumSet<CreateFlag> flag, final int bufferSize, final Progressable progress, final InetSocketAddress[] favoredNodes) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.APPEND);
        Path absF = this.fixRelativePart(f);
        return (FSDataOutputStream)new FileSystemLinkResolver<FSDataOutputStream>(){

            public FSDataOutputStream doCall(Path p) throws IOException {
                return DistributedFileSystem.this.dfs.append(DistributedFileSystem.this.getPathName(p), bufferSize, flag, progress, DistributedFileSystem.this.statistics, favoredNodes);
            }

            public FSDataOutputStream next(FileSystem fs, Path p) throws IOException {
                return fs.append(p, bufferSize);
            }
        }.resolve((FileSystem)this, absF);
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.create(f, permission, overwrite ? EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE) : EnumSet.of(CreateFlag.CREATE), bufferSize, replication, blockSize, progress, null);
    }

    public HdfsDataOutputStream create(final Path f, final FsPermission permission, final boolean overwrite, final int bufferSize, final short replication, final long blockSize, final Progressable progress, final InetSocketAddress[] favoredNodes) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.CREATE);
        Path absF = this.fixRelativePart(f);
        return (HdfsDataOutputStream)((Object)new FileSystemLinkResolver<HdfsDataOutputStream>(){

            public HdfsDataOutputStream doCall(Path p) throws IOException {
                DFSOutputStream out = DistributedFileSystem.this.dfs.create(DistributedFileSystem.this.getPathName(f), permission, overwrite ? EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE) : EnumSet.of(CreateFlag.CREATE), true, replication, blockSize, progress, bufferSize, null, favoredNodes);
                return DistributedFileSystem.this.dfs.createWrappedOutputStream(out, DistributedFileSystem.this.statistics);
            }

            public HdfsDataOutputStream next(FileSystem fs, Path p) throws IOException {
                if (fs instanceof DistributedFileSystem) {
                    DistributedFileSystem myDfs = (DistributedFileSystem)fs;
                    return myDfs.create(p, permission, overwrite, bufferSize, replication, blockSize, progress, favoredNodes);
                }
                throw new UnsupportedOperationException("Cannot create with favoredNodes through a symlink to a non-DistributedFileSystem: " + f + " -> " + p);
            }
        }.resolve((FileSystem)this, absF));
    }

    public FSDataOutputStream create(Path f, final FsPermission permission, final EnumSet<CreateFlag> cflags, final int bufferSize, final short replication, final long blockSize, final Progressable progress, final Options.ChecksumOpt checksumOpt) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.CREATE);
        Path absF = this.fixRelativePart(f);
        return (FSDataOutputStream)new FileSystemLinkResolver<FSDataOutputStream>(){

            public FSDataOutputStream doCall(Path p) throws IOException {
                DFSOutputStream dfsos = DistributedFileSystem.this.dfs.create(DistributedFileSystem.this.getPathName(p), permission, cflags, replication, blockSize, progress, bufferSize, checksumOpt);
                return DistributedFileSystem.this.dfs.createWrappedOutputStream(dfsos, DistributedFileSystem.this.statistics);
            }

            public FSDataOutputStream next(FileSystem fs, Path p) throws IOException {
                return fs.create(p, permission, cflags, bufferSize, replication, blockSize, progress, checksumOpt);
            }
        }.resolve((FileSystem)this, absF);
    }

    private HdfsDataOutputStream create(final Path f, final FsPermission permission, final EnumSet<CreateFlag> flag, final int bufferSize, final short replication, final long blockSize, final Progressable progress, final Options.ChecksumOpt checksumOpt, final InetSocketAddress[] favoredNodes, final String ecPolicyName) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.CREATE);
        Path absF = this.fixRelativePart(f);
        return (HdfsDataOutputStream)((Object)new FileSystemLinkResolver<HdfsDataOutputStream>(){

            public HdfsDataOutputStream doCall(Path p) throws IOException {
                DFSOutputStream out = DistributedFileSystem.this.dfs.create(DistributedFileSystem.this.getPathName(f), permission, flag, true, replication, blockSize, progress, bufferSize, checksumOpt, favoredNodes, ecPolicyName);
                return DistributedFileSystem.this.dfs.createWrappedOutputStream(out, DistributedFileSystem.this.statistics);
            }

            public HdfsDataOutputStream next(FileSystem fs, Path p) throws IOException {
                if (fs instanceof DistributedFileSystem) {
                    DistributedFileSystem myDfs = (DistributedFileSystem)fs;
                    return myDfs.create(p, permission, flag, bufferSize, replication, blockSize, progress, checksumOpt, favoredNodes, ecPolicyName);
                }
                throw new UnsupportedOperationException("Cannot create with favoredNodes through a symlink to a non-DistributedFileSystem: " + f + " -> " + p);
            }
        }.resolve((FileSystem)this, absF));
    }

    protected HdfsDataOutputStream primitiveCreate(Path f, FsPermission absolutePermission, EnumSet<CreateFlag> flag, int bufferSize, short replication, long blockSize, Progressable progress, Options.ChecksumOpt checksumOpt) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.PRIMITIVE_CREATE);
        DFSOutputStream dfsos = this.dfs.primitiveCreate(this.getPathName(this.fixRelativePart(f)), absolutePermission, flag, true, replication, blockSize, progress, bufferSize, checksumOpt);
        return this.dfs.createWrappedOutputStream(dfsos, this.statistics);
    }

    private HdfsDataOutputStream createNonRecursive(final Path f, final FsPermission permission, final EnumSet<CreateFlag> flag, final int bufferSize, final short replication, final long blockSize, final Progressable progress, final Options.ChecksumOpt checksumOpt, final InetSocketAddress[] favoredNodes, final String ecPolicyName) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.CREATE);
        Path absF = this.fixRelativePart(f);
        return (HdfsDataOutputStream)((Object)new FileSystemLinkResolver<HdfsDataOutputStream>(){

            public HdfsDataOutputStream doCall(Path p) throws IOException {
                DFSOutputStream out = DistributedFileSystem.this.dfs.create(DistributedFileSystem.this.getPathName(f), permission, flag, false, replication, blockSize, progress, bufferSize, checksumOpt, favoredNodes, ecPolicyName);
                return DistributedFileSystem.this.dfs.createWrappedOutputStream(out, DistributedFileSystem.this.statistics);
            }

            public HdfsDataOutputStream next(FileSystem fs, Path p) throws IOException {
                if (fs instanceof DistributedFileSystem) {
                    DistributedFileSystem myDfs = (DistributedFileSystem)fs;
                    return myDfs.createNonRecursive(p, permission, flag, bufferSize, replication, blockSize, progress, checksumOpt, favoredNodes, ecPolicyName);
                }
                throw new UnsupportedOperationException("Cannot create with favoredNodes through a symlink to a non-DistributedFileSystem: " + f + " -> " + p);
            }
        }.resolve((FileSystem)this, absF));
    }

    public FSDataOutputStream createNonRecursive(Path f, final FsPermission permission, final EnumSet<CreateFlag> flag, final int bufferSize, final short replication, final long blockSize, final Progressable progress) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.CREATE_NON_RECURSIVE);
        if (flag.contains(CreateFlag.OVERWRITE)) {
            flag.add(CreateFlag.CREATE);
        }
        Path absF = this.fixRelativePart(f);
        return (FSDataOutputStream)new FileSystemLinkResolver<FSDataOutputStream>(){

            public FSDataOutputStream doCall(Path p) throws IOException {
                DFSOutputStream dfsos = DistributedFileSystem.this.dfs.create(DistributedFileSystem.this.getPathName(p), permission, flag, false, replication, blockSize, progress, bufferSize, null);
                return DistributedFileSystem.this.dfs.createWrappedOutputStream(dfsos, DistributedFileSystem.this.statistics);
            }

            public FSDataOutputStream next(FileSystem fs, Path p) throws IOException {
                return fs.createNonRecursive(p, permission, flag, bufferSize, replication, blockSize, progress);
            }
        }.resolve((FileSystem)this, absF);
    }

    public boolean setReplication(Path src, final short replication) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.SET_REPLICATION);
        Path absF = this.fixRelativePart(src);
        return (Boolean)new FileSystemLinkResolver<Boolean>(){

            public Boolean doCall(Path p) throws IOException {
                return DistributedFileSystem.this.dfs.setReplication(DistributedFileSystem.this.getPathName(p), replication);
            }

            public Boolean next(FileSystem fs, Path p) throws IOException {
                return fs.setReplication(p, replication);
            }
        }.resolve((FileSystem)this, absF);
    }

    public void setStoragePolicy(Path src, final String policyName) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.SET_STORAGE_POLICY);
        Path absF = this.fixRelativePart(src);
        new FileSystemLinkResolver<Void>(){

            public Void doCall(Path p) throws IOException {
                DistributedFileSystem.this.dfs.setStoragePolicy(DistributedFileSystem.this.getPathName(p), policyName);
                return null;
            }

            public Void next(FileSystem fs, Path p) throws IOException {
                fs.setStoragePolicy(p, policyName);
                return null;
            }
        }.resolve((FileSystem)this, absF);
    }

    public void unsetStoragePolicy(final Path src) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.UNSET_STORAGE_POLICY);
        Path absF = this.fixRelativePart(src);
        new FileSystemLinkResolver<Void>(){

            public Void doCall(Path p) throws IOException {
                DistributedFileSystem.this.dfs.unsetStoragePolicy(DistributedFileSystem.this.getPathName(p));
                return null;
            }

            public Void next(FileSystem fs, Path p) throws IOException {
                if (fs instanceof DistributedFileSystem) {
                    ((DistributedFileSystem)fs).unsetStoragePolicy(p);
                    return null;
                }
                throw new UnsupportedOperationException("Cannot perform unsetStoragePolicy on a non-DistributedFileSystem: " + src + " -> " + p);
            }
        }.resolve((FileSystem)this, absF);
    }

    public BlockStoragePolicySpi getStoragePolicy(Path path) throws IOException {
        this.statistics.incrementReadOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.GET_STORAGE_POLICY);
        Path absF = this.fixRelativePart(path);
        return (BlockStoragePolicySpi)new FileSystemLinkResolver<BlockStoragePolicySpi>(){

            public BlockStoragePolicySpi doCall(Path p) throws IOException {
                return DistributedFileSystem.this.getClient().getStoragePolicy(DistributedFileSystem.this.getPathName(p));
            }

            public BlockStoragePolicySpi next(FileSystem fs, Path p) throws IOException {
                return fs.getStoragePolicy(p);
            }
        }.resolve((FileSystem)this, absF);
    }

    public Collection<BlockStoragePolicy> getAllStoragePolicies() throws IOException {
        return Arrays.asList(this.dfs.getStoragePolicies());
    }

    public long getBytesWithFutureGenerationStamps() throws IOException {
        this.statistics.incrementReadOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.GET_BYTES_WITH_FUTURE_GS);
        return this.dfs.getBytesInFutureBlocks();
    }

    @Deprecated
    public BlockStoragePolicy[] getStoragePolicies() throws IOException {
        this.statistics.incrementReadOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.GET_STORAGE_POLICIES);
        return this.dfs.getStoragePolicies();
    }

    public void concat(Path trg, Path[] psrcs) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.CONCAT);
        Path absF = this.fixRelativePart(trg);
        Path[] srcs = new Path[psrcs.length];
        for (int i = 0; i < psrcs.length; ++i) {
            srcs[i] = this.fixRelativePart(psrcs[i]);
        }
        String[] srcsStr = new String[psrcs.length];
        try {
            for (int i = 0; i < psrcs.length; ++i) {
                srcsStr[i] = this.getPathName(srcs[i]);
            }
            this.dfs.concat(this.getPathName(absF), srcsStr);
        }
        catch (UnresolvedLinkException e) {
            int i;
            FileStatus stat = this.getFileLinkStatus(absF);
            if (stat.isSymlink()) {
                throw new IOException("Cannot concat with a symlink target: " + trg + " -> " + stat.getPath());
            }
            absF = this.fixRelativePart(stat.getPath());
            for (i = 0; i < psrcs.length; ++i) {
                stat = this.getFileLinkStatus(srcs[i]);
                if (stat.isSymlink()) {
                    throw new IOException("Cannot concat with a symlink src: " + psrcs[i] + " -> " + stat.getPath());
                }
                srcs[i] = this.fixRelativePart(stat.getPath());
            }
            for (i = 0; i < psrcs.length; ++i) {
                srcsStr[i] = this.getPathName(srcs[i]);
            }
            this.dfs.concat(this.getPathName(absF), srcsStr);
        }
    }

    public boolean rename(Path src, Path dst) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.RENAME);
        Path absSrc = this.fixRelativePart(src);
        Path absDst = this.fixRelativePart(dst);
        try {
            return this.dfs.rename(this.getPathName(absSrc), this.getPathName(absDst));
        }
        catch (UnresolvedLinkException e) {
            final Path source = this.getFileLinkStatus(absSrc).getPath();
            return (Boolean)new FileSystemLinkResolver<Boolean>(){

                public Boolean doCall(Path p) throws IOException {
                    return DistributedFileSystem.this.dfs.rename(DistributedFileSystem.this.getPathName(source), DistributedFileSystem.this.getPathName(p));
                }

                public Boolean next(FileSystem fs, Path p) throws IOException {
                    return this.doCall(p);
                }
            }.resolve((FileSystem)this, absDst);
        }
    }

    public void rename(Path src, Path dst, final Options.Rename ... options) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.RENAME);
        Path absSrc = this.fixRelativePart(src);
        Path absDst = this.fixRelativePart(dst);
        try {
            this.dfs.rename(this.getPathName(absSrc), this.getPathName(absDst), options);
        }
        catch (UnresolvedLinkException e) {
            final Path source = this.getFileLinkStatus(absSrc).getPath();
            new FileSystemLinkResolver<Void>(){

                public Void doCall(Path p) throws IOException {
                    DistributedFileSystem.this.dfs.rename(DistributedFileSystem.this.getPathName(source), DistributedFileSystem.this.getPathName(p), options);
                    return null;
                }

                public Void next(FileSystem fs, Path p) throws IOException {
                    return this.doCall(p);
                }
            }.resolve((FileSystem)this, absDst);
        }
    }

    public boolean truncate(Path f, final long newLength) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.TRUNCATE);
        Path absF = this.fixRelativePart(f);
        return (Boolean)new FileSystemLinkResolver<Boolean>(){

            public Boolean doCall(Path p) throws IOException {
                return DistributedFileSystem.this.dfs.truncate(DistributedFileSystem.this.getPathName(p), newLength);
            }

            public Boolean next(FileSystem fs, Path p) throws IOException {
                return fs.truncate(p, newLength);
            }
        }.resolve((FileSystem)this, absF);
    }

    public boolean delete(Path f, final boolean recursive) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.DELETE);
        Path absF = this.fixRelativePart(f);
        return (Boolean)new FileSystemLinkResolver<Boolean>(){

            public Boolean doCall(Path p) throws IOException {
                return DistributedFileSystem.this.dfs.delete(DistributedFileSystem.this.getPathName(p), recursive);
            }

            public Boolean next(FileSystem fs, Path p) throws IOException {
                return fs.delete(p, recursive);
            }
        }.resolve((FileSystem)this, absF);
    }

    public ContentSummary getContentSummary(Path f) throws IOException {
        this.statistics.incrementReadOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.GET_CONTENT_SUMMARY);
        Path absF = this.fixRelativePart(f);
        return (ContentSummary)new FileSystemLinkResolver<ContentSummary>(){

            public ContentSummary doCall(Path p) throws IOException {
                return DistributedFileSystem.this.dfs.getContentSummary(DistributedFileSystem.this.getPathName(p));
            }

            public ContentSummary next(FileSystem fs, Path p) throws IOException {
                return fs.getContentSummary(p);
            }
        }.resolve((FileSystem)this, absF);
    }

    public QuotaUsage getQuotaUsage(Path f) throws IOException {
        this.statistics.incrementReadOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.GET_QUOTA_USAGE);
        Path absF = this.fixRelativePart(f);
        return (QuotaUsage)new FileSystemLinkResolver<QuotaUsage>(){

            public QuotaUsage doCall(Path p) throws IOException, UnresolvedLinkException {
                return DistributedFileSystem.this.dfs.getQuotaUsage(DistributedFileSystem.this.getPathName(p));
            }

            public QuotaUsage next(FileSystem fs, Path p) throws IOException {
                return fs.getQuotaUsage(p);
            }
        }.resolve((FileSystem)this, absF);
    }

    public void setQuota(Path src, final long namespaceQuota, final long storagespaceQuota) throws IOException {
        Path absF = this.fixRelativePart(src);
        new FileSystemLinkResolver<Void>(){

            public Void doCall(Path p) throws IOException {
                DistributedFileSystem.this.dfs.setQuota(DistributedFileSystem.this.getPathName(p), namespaceQuota, storagespaceQuota);
                return null;
            }

            public Void next(FileSystem fs, Path p) throws IOException {
                return this.doCall(p);
            }
        }.resolve((FileSystem)this, absF);
    }

    public void setQuotaByStorageType(Path src, final StorageType type, final long quota) throws IOException {
        Path absF = this.fixRelativePart(src);
        new FileSystemLinkResolver<Void>(){

            public Void doCall(Path p) throws IOException {
                DistributedFileSystem.this.dfs.setQuotaByStorageType(DistributedFileSystem.this.getPathName(p), type, quota);
                return null;
            }

            public Void next(FileSystem fs, Path p) throws IOException {
                return this.doCall(p);
            }
        }.resolve((FileSystem)this, absF);
    }

    private FileStatus[] listStatusInternal(Path p) throws IOException {
        String src = this.getPathName(p);
        DirectoryListing thisListing = this.dfs.listPaths(src, HdfsFileStatus.EMPTY_NAME);
        if (thisListing == null) {
            throw new FileNotFoundException("File " + p + " does not exist.");
        }
        HdfsFileStatus[] partialListing = thisListing.getPartialListing();
        if (!thisListing.hasMore()) {
            FileStatus[] stats = new FileStatus[partialListing.length];
            for (int i = 0; i < partialListing.length; ++i) {
                stats[i] = partialListing[i].makeQualified(this.getUri(), p);
            }
            this.statistics.incrementReadOps(1);
            this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.LIST_STATUS);
            return stats;
        }
        int totalNumEntries = partialListing.length + thisListing.getRemainingEntries();
        ArrayList<FileStatus> listing = new ArrayList<FileStatus>(totalNumEntries);
        for (HdfsFileStatus fileStatus : partialListing) {
            listing.add(fileStatus.makeQualified(this.getUri(), p));
        }
        this.statistics.incrementLargeReadOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.LIST_STATUS);
        do {
            if ((thisListing = this.dfs.listPaths(src, thisListing.getLastName())) == null) {
                throw new FileNotFoundException("File " + p + " does not exist.");
            }
            for (HdfsFileStatus fileStatus : partialListing = thisListing.getPartialListing()) {
                listing.add(fileStatus.makeQualified(this.getUri(), p));
            }
            this.statistics.incrementLargeReadOps(1);
            this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.LIST_STATUS);
        } while (thisListing.hasMore());
        return listing.toArray(new FileStatus[listing.size()]);
    }

    public FileStatus[] listStatus(Path p) throws IOException {
        Path absF = this.fixRelativePart(p);
        return (FileStatus[])new FileSystemLinkResolver<FileStatus[]>(){

            public FileStatus[] doCall(Path p) throws IOException {
                return DistributedFileSystem.this.listStatusInternal(p);
            }

            public FileStatus[] next(FileSystem fs, Path p) throws IOException {
                return fs.listStatus(p);
            }
        }.resolve((FileSystem)this, absF);
    }

    protected RemoteIterator<LocatedFileStatus> listLocatedStatus(Path p, final PathFilter filter) throws IOException {
        Path absF = this.fixRelativePart(p);
        return (RemoteIterator)new FileSystemLinkResolver<RemoteIterator<LocatedFileStatus>>(){

            public RemoteIterator<LocatedFileStatus> doCall(Path p) throws IOException {
                return new DirListingIterator<LocatedFileStatus>(p, filter, true);
            }

            public RemoteIterator<LocatedFileStatus> next(FileSystem fs, Path p) throws IOException {
                if (fs instanceof DistributedFileSystem) {
                    return ((DistributedFileSystem)fs).listLocatedStatus(p, filter);
                }
                throw new IOException("Link resolution does not work with multiple file systems for listLocatedStatus(): " + p);
            }
        }.resolve((FileSystem)this, absF);
    }

    public RemoteIterator<FileStatus> listStatusIterator(Path p) throws IOException {
        Path absF = this.fixRelativePart(p);
        return (RemoteIterator)new FileSystemLinkResolver<RemoteIterator<FileStatus>>(){

            public RemoteIterator<FileStatus> doCall(Path p) throws IOException {
                return new DirListingIterator<FileStatus>(p, false);
            }

            public RemoteIterator<FileStatus> next(FileSystem fs, Path p) throws IOException {
                return ((DistributedFileSystem)fs).listStatusIterator(p);
            }
        }.resolve((FileSystem)this, absF);
    }

    public boolean mkdir(Path f, FsPermission permission) throws IOException {
        return this.mkdirsInternal(f, permission, false);
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        return this.mkdirsInternal(f, permission, true);
    }

    private boolean mkdirsInternal(Path f, final FsPermission permission, final boolean createParent) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.MKDIRS);
        Path absF = this.fixRelativePart(f);
        return (Boolean)new FileSystemLinkResolver<Boolean>(){

            public Boolean doCall(Path p) throws IOException {
                return DistributedFileSystem.this.dfs.mkdirs(DistributedFileSystem.this.getPathName(p), permission, createParent);
            }

            public Boolean next(FileSystem fs, Path p) throws IOException {
                if (!createParent) {
                    throw new IOException("FileSystem does not support non-recursivemkdir");
                }
                return fs.mkdirs(p, permission);
            }
        }.resolve((FileSystem)this, absF);
    }

    protected boolean primitiveMkdir(Path f, FsPermission absolutePermission) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.PRIMITIVE_MKDIR);
        return this.dfs.primitiveMkdir(this.getPathName(f), absolutePermission);
    }

    public void close() throws IOException {
        try {
            this.dfs.closeOutputStreams(false);
            super.close();
        }
        finally {
            this.dfs.close();
        }
    }

    public String toString() {
        return "DFS[" + this.dfs + "]";
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public DFSClient getClient() {
        return this.dfs;
    }

    public FsStatus getStatus(Path p) throws IOException {
        this.statistics.incrementReadOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.GET_STATUS);
        return this.dfs.getDiskStatus();
    }

    public long getMissingBlocksCount() throws IOException {
        return this.dfs.getMissingBlocksCount();
    }

    public long getPendingDeletionBlocksCount() throws IOException {
        return this.dfs.getPendingDeletionBlocksCount();
    }

    public long getMissingReplOneBlocksCount() throws IOException {
        return this.dfs.getMissingReplOneBlocksCount();
    }

    public long getLowRedundancyBlocksCount() throws IOException {
        return this.dfs.getLowRedundancyBlocksCount();
    }

    public long getCorruptBlocksCount() throws IOException {
        return this.dfs.getCorruptBlocksCount();
    }

    public RemoteIterator<Path> listCorruptFileBlocks(Path path) throws IOException {
        Path absF = this.fixRelativePart(path);
        return (RemoteIterator)new FileSystemLinkResolver<RemoteIterator<Path>>(){

            public RemoteIterator<Path> doCall(Path path) throws IOException, UnresolvedLinkException {
                return new CorruptFileBlockIterator(DistributedFileSystem.this.dfs, path);
            }

            public RemoteIterator<Path> next(FileSystem fs, Path path) throws IOException {
                return fs.listCorruptFileBlocks(path);
            }
        }.resolve((FileSystem)this, absF);
    }

    public DatanodeInfo[] getDataNodeStats() throws IOException {
        return this.getDataNodeStats(HdfsConstants.DatanodeReportType.ALL);
    }

    public DatanodeInfo[] getDataNodeStats(HdfsConstants.DatanodeReportType type) throws IOException {
        return this.dfs.datanodeReport(type);
    }

    public boolean setSafeMode(HdfsConstants.SafeModeAction action) throws IOException {
        return this.setSafeMode(action, false);
    }

    public boolean setSafeMode(HdfsConstants.SafeModeAction action, boolean isChecked) throws IOException {
        return this.dfs.setSafeMode(action, isChecked);
    }

    public boolean saveNamespace(long timeWindow, long txGap) throws IOException {
        return this.dfs.saveNamespace(timeWindow, txGap);
    }

    public void saveNamespace() throws IOException {
        this.saveNamespace(0L, 0L);
    }

    public long rollEdits() throws IOException {
        return this.dfs.rollEdits();
    }

    public boolean restoreFailedStorage(String arg) throws IOException {
        return this.dfs.restoreFailedStorage(arg);
    }

    public void refreshNodes() throws IOException {
        this.dfs.refreshNodes();
    }

    public void finalizeUpgrade() throws IOException {
        this.dfs.finalizeUpgrade();
    }

    public boolean upgradeStatus() throws IOException {
        return this.dfs.upgradeStatus();
    }

    public RollingUpgradeInfo rollingUpgrade(HdfsConstants.RollingUpgradeAction action) throws IOException {
        return this.dfs.rollingUpgrade(action);
    }

    public void metaSave(String pathname) throws IOException {
        this.dfs.metaSave(pathname);
    }

    public FsServerDefaults getServerDefaults() throws IOException {
        return this.dfs.getServerDefaults();
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        this.statistics.incrementReadOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.GET_FILE_STATUS);
        Path absF = this.fixRelativePart(f);
        return (FileStatus)new FileSystemLinkResolver<FileStatus>(){

            public FileStatus doCall(Path p) throws IOException {
                HdfsFileStatus fi = DistributedFileSystem.this.dfs.getFileInfo(DistributedFileSystem.this.getPathName(p));
                if (fi != null) {
                    return fi.makeQualified(DistributedFileSystem.this.getUri(), p);
                }
                throw new FileNotFoundException("File does not exist: " + p);
            }

            public FileStatus next(FileSystem fs, Path p) throws IOException {
                return fs.getFileStatus(p);
            }
        }.resolve((FileSystem)this, absF);
    }

    public void createSymlink(final Path target, Path link, final boolean createParent) throws IOException {
        if (!FileSystem.areSymlinksEnabled()) {
            throw new UnsupportedOperationException("Symlinks not supported");
        }
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.CREATE_SYM_LINK);
        Path absF = this.fixRelativePart(link);
        new FileSystemLinkResolver<Void>(){

            public Void doCall(Path p) throws IOException {
                DistributedFileSystem.this.dfs.createSymlink(target.toString(), DistributedFileSystem.this.getPathName(p), createParent);
                return null;
            }

            public Void next(FileSystem fs, Path p) throws IOException {
                fs.createSymlink(target, p, createParent);
                return null;
            }
        }.resolve((FileSystem)this, absF);
    }

    public boolean supportsSymlinks() {
        return true;
    }

    public FileStatus getFileLinkStatus(Path f) throws IOException {
        this.statistics.incrementReadOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.GET_FILE_LINK_STATUS);
        Path absF = this.fixRelativePart(f);
        FileStatus status = (FileStatus)new FileSystemLinkResolver<FileStatus>(){

            public FileStatus doCall(Path p) throws IOException {
                HdfsFileStatus fi = DistributedFileSystem.this.dfs.getFileLinkInfo(DistributedFileSystem.this.getPathName(p));
                if (fi != null) {
                    return fi.makeQualified(DistributedFileSystem.this.getUri(), p);
                }
                throw new FileNotFoundException("File does not exist: " + p);
            }

            public FileStatus next(FileSystem fs, Path p) throws IOException {
                return fs.getFileLinkStatus(p);
            }
        }.resolve((FileSystem)this, absF);
        if (status.isSymlink()) {
            Path targetQual = FSLinkResolver.qualifySymlinkTarget((URI)this.getUri(), (Path)status.getPath(), (Path)status.getSymlink());
            status.setSymlink(targetQual);
        }
        return status;
    }

    public Path getLinkTarget(Path f) throws IOException {
        this.statistics.incrementReadOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.GET_LINK_TARGET);
        Path absF = this.fixRelativePart(f);
        return (Path)new FileSystemLinkResolver<Path>(){

            public Path doCall(Path p) throws IOException {
                HdfsFileStatus fi = DistributedFileSystem.this.dfs.getFileLinkInfo(DistributedFileSystem.this.getPathName(p));
                if (fi != null) {
                    return fi.makeQualified(DistributedFileSystem.this.getUri(), p).getSymlink();
                }
                throw new FileNotFoundException("File does not exist: " + p);
            }

            public Path next(FileSystem fs, Path p) throws IOException {
                return fs.getLinkTarget(p);
            }
        }.resolve((FileSystem)this, absF);
    }

    protected Path resolveLink(Path f) throws IOException {
        this.statistics.incrementReadOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.RESOLVE_LINK);
        String target = this.dfs.getLinkTarget(this.getPathName(this.fixRelativePart(f)));
        if (target == null) {
            throw new FileNotFoundException("File does not exist: " + f.toString());
        }
        return new Path(target);
    }

    public FileChecksum getFileChecksum(Path f) throws IOException {
        this.statistics.incrementReadOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.GET_FILE_CHECKSUM);
        Path absF = this.fixRelativePart(f);
        return (FileChecksum)new FileSystemLinkResolver<FileChecksum>(){

            public FileChecksum doCall(Path p) throws IOException {
                return DistributedFileSystem.this.dfs.getFileChecksumWithCombineMode(DistributedFileSystem.this.getPathName(p), Long.MAX_VALUE);
            }

            public FileChecksum next(FileSystem fs, Path p) throws IOException {
                return fs.getFileChecksum(p);
            }
        }.resolve((FileSystem)this, absF);
    }

    public FileChecksum getFileChecksum(Path f, final long length) throws IOException {
        this.statistics.incrementReadOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.GET_FILE_CHECKSUM);
        Path absF = this.fixRelativePart(f);
        return (FileChecksum)new FileSystemLinkResolver<FileChecksum>(){

            public FileChecksum doCall(Path p) throws IOException {
                return DistributedFileSystem.this.dfs.getFileChecksumWithCombineMode(DistributedFileSystem.this.getPathName(p), length);
            }

            public FileChecksum next(FileSystem fs, Path p) throws IOException {
                if (fs instanceof DistributedFileSystem) {
                    return fs.getFileChecksum(p, length);
                }
                throw new UnsupportedFileSystemException("getFileChecksum(Path, long) is not supported by " + fs.getClass().getSimpleName());
            }
        }.resolve((FileSystem)this, absF);
    }

    public void setPermission(Path p, final FsPermission permission) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.SET_PERMISSION);
        Path absF = this.fixRelativePart(p);
        new FileSystemLinkResolver<Void>(){

            public Void doCall(Path p) throws IOException {
                DistributedFileSystem.this.dfs.setPermission(DistributedFileSystem.this.getPathName(p), permission);
                return null;
            }

            public Void next(FileSystem fs, Path p) throws IOException {
                fs.setPermission(p, permission);
                return null;
            }
        }.resolve((FileSystem)this, absF);
    }

    public void setOwner(Path p, final String username, final String groupname) throws IOException {
        if (username == null && groupname == null) {
            throw new IOException("username == null && groupname == null");
        }
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.SET_OWNER);
        Path absF = this.fixRelativePart(p);
        new FileSystemLinkResolver<Void>(){

            public Void doCall(Path p) throws IOException {
                DistributedFileSystem.this.dfs.setOwner(DistributedFileSystem.this.getPathName(p), username, groupname);
                return null;
            }

            public Void next(FileSystem fs, Path p) throws IOException {
                fs.setOwner(p, username, groupname);
                return null;
            }
        }.resolve((FileSystem)this, absF);
    }

    public void setTimes(Path p, final long mtime, final long atime) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.SET_TIMES);
        Path absF = this.fixRelativePart(p);
        new FileSystemLinkResolver<Void>(){

            public Void doCall(Path p) throws IOException {
                DistributedFileSystem.this.dfs.setTimes(DistributedFileSystem.this.getPathName(p), mtime, atime);
                return null;
            }

            public Void next(FileSystem fs, Path p) throws IOException {
                fs.setTimes(p, mtime, atime);
                return null;
            }
        }.resolve((FileSystem)this, absF);
    }

    protected int getDefaultPort() {
        return 8020;
    }

    public Token<DelegationTokenIdentifier> getDelegationToken(String renewer) throws IOException {
        return this.dfs.getDelegationToken(renewer == null ? null : new Text(renewer));
    }

    public void setBalancerBandwidth(long bandwidth) throws IOException {
        this.dfs.setBalancerBandwidth(bandwidth);
    }

    public String getCanonicalServiceName() {
        return this.dfs.getCanonicalServiceName();
    }

    protected URI canonicalizeUri(URI uri) {
        if (HAUtilClient.isLogicalUri(this.getConf(), uri)) {
            return uri;
        }
        return NetUtils.getCanonicalUri((URI)uri, (int)this.getDefaultPort());
    }

    public boolean isInSafeMode() throws IOException {
        return this.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_GET, true);
    }

    public void allowSnapshot(final Path path) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.ALLOW_SNAPSHOT);
        Path absF = this.fixRelativePart(path);
        new FileSystemLinkResolver<Void>(){

            public Void doCall(Path p) throws IOException {
                DistributedFileSystem.this.dfs.allowSnapshot(DistributedFileSystem.this.getPathName(p));
                return null;
            }

            public Void next(FileSystem fs, Path p) throws IOException {
                if (!(fs instanceof DistributedFileSystem)) {
                    throw new UnsupportedOperationException("Cannot perform snapshot operations on a symlink to a non-DistributedFileSystem: " + path + " -> " + p);
                }
                DistributedFileSystem myDfs = (DistributedFileSystem)fs;
                myDfs.allowSnapshot(p);
                return null;
            }
        }.resolve((FileSystem)this, absF);
    }

    public void disallowSnapshot(final Path path) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.DISALLOW_SNAPSHOT);
        Path absF = this.fixRelativePart(path);
        new FileSystemLinkResolver<Void>(){

            public Void doCall(Path p) throws IOException {
                DistributedFileSystem.this.dfs.disallowSnapshot(DistributedFileSystem.this.getPathName(p));
                return null;
            }

            public Void next(FileSystem fs, Path p) throws IOException {
                if (!(fs instanceof DistributedFileSystem)) {
                    throw new UnsupportedOperationException("Cannot perform snapshot operations on a symlink to a non-DistributedFileSystem: " + path + " -> " + p);
                }
                DistributedFileSystem myDfs = (DistributedFileSystem)fs;
                myDfs.disallowSnapshot(p);
                return null;
            }
        }.resolve((FileSystem)this, absF);
    }

    public Path createSnapshot(final Path path, final String snapshotName) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.CREATE_SNAPSHOT);
        Path absF = this.fixRelativePart(path);
        return (Path)new FileSystemLinkResolver<Path>(){

            public Path doCall(Path p) throws IOException {
                return new Path(DistributedFileSystem.this.dfs.createSnapshot(DistributedFileSystem.this.getPathName(p), snapshotName));
            }

            public Path next(FileSystem fs, Path p) throws IOException {
                if (fs instanceof DistributedFileSystem) {
                    DistributedFileSystem myDfs = (DistributedFileSystem)fs;
                    return myDfs.createSnapshot(p);
                }
                throw new UnsupportedOperationException("Cannot perform snapshot operations on a symlink to a non-DistributedFileSystem: " + path + " -> " + p);
            }
        }.resolve((FileSystem)this, absF);
    }

    public void renameSnapshot(final Path path, final String snapshotOldName, final String snapshotNewName) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.RENAME_SNAPSHOT);
        Path absF = this.fixRelativePart(path);
        new FileSystemLinkResolver<Void>(){

            public Void doCall(Path p) throws IOException {
                DistributedFileSystem.this.dfs.renameSnapshot(DistributedFileSystem.this.getPathName(p), snapshotOldName, snapshotNewName);
                return null;
            }

            public Void next(FileSystem fs, Path p) throws IOException {
                if (!(fs instanceof DistributedFileSystem)) {
                    throw new UnsupportedOperationException("Cannot perform snapshot operations on a symlink to a non-DistributedFileSystem: " + path + " -> " + p);
                }
                DistributedFileSystem myDfs = (DistributedFileSystem)fs;
                myDfs.renameSnapshot(p, snapshotOldName, snapshotNewName);
                return null;
            }
        }.resolve((FileSystem)this, absF);
    }

    public SnapshottableDirectoryStatus[] getSnapshottableDirListing() throws IOException {
        return this.dfs.getSnapshottableDirListing();
    }

    public void deleteSnapshot(final Path snapshotDir, final String snapshotName) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.DELETE_SNAPSHOT);
        Path absF = this.fixRelativePart(snapshotDir);
        new FileSystemLinkResolver<Void>(){

            public Void doCall(Path p) throws IOException {
                DistributedFileSystem.this.dfs.deleteSnapshot(DistributedFileSystem.this.getPathName(p), snapshotName);
                return null;
            }

            public Void next(FileSystem fs, Path p) throws IOException {
                if (!(fs instanceof DistributedFileSystem)) {
                    throw new UnsupportedOperationException("Cannot perform snapshot operations on a symlink to a non-DistributedFileSystem: " + snapshotDir + " -> " + p);
                }
                DistributedFileSystem myDfs = (DistributedFileSystem)fs;
                myDfs.deleteSnapshot(p, snapshotName);
                return null;
            }
        }.resolve((FileSystem)this, absF);
    }

    public RemoteIterator<SnapshotDiffReportListing> snapshotDiffReportListingRemoteIterator(Path snapshotDir, final String fromSnapshot, final String toSnapshot) throws IOException {
        Path absF = this.fixRelativePart(snapshotDir);
        return (RemoteIterator)new FileSystemLinkResolver<RemoteIterator<SnapshotDiffReportListing>>(){

            public RemoteIterator<SnapshotDiffReportListing> doCall(Path p) throws IOException {
                if (!DistributedFileSystem.this.isValidSnapshotName(fromSnapshot) || !DistributedFileSystem.this.isValidSnapshotName(toSnapshot)) {
                    throw new UnsupportedOperationException("Remote Iterator issupported for snapshotDiffReport between two snapshots");
                }
                return new SnapshotDiffReportListingIterator(DistributedFileSystem.this.getPathName(p), fromSnapshot, toSnapshot);
            }

            public RemoteIterator<SnapshotDiffReportListing> next(FileSystem fs, Path p) throws IOException {
                return ((DistributedFileSystem)fs).snapshotDiffReportListingRemoteIterator(p, fromSnapshot, toSnapshot);
            }
        }.resolve((FileSystem)this, absF);
    }

    private boolean isValidSnapshotName(String snapshotName) {
        return snapshotName != null && !snapshotName.isEmpty();
    }

    private SnapshotDiffReport getSnapshotDiffReportInternal(String snapshotDir, String fromSnapshot, String toSnapshot) throws IOException {
        SnapshotDiffReportListing report;
        if (!this.isValidSnapshotName(fromSnapshot) || !this.isValidSnapshotName(toSnapshot)) {
            return this.dfs.getSnapshotDiffReport(snapshotDir, fromSnapshot, toSnapshot);
        }
        byte[] startPath = DFSUtilClient.EMPTY_BYTES;
        int index = -1;
        TreeList modifiedList = new TreeList();
        ChunkedArrayList createdList = new ChunkedArrayList();
        ChunkedArrayList deletedList = new ChunkedArrayList();
        do {
            report = this.dfs.getSnapshotDiffReportListing(snapshotDir, fromSnapshot, toSnapshot, startPath, index);
            startPath = report.getLastPath();
            index = report.getLastIndex();
            modifiedList.addAll(report.getModifyList());
            createdList.addAll(report.getCreateList());
            deletedList.addAll(report.getDeleteList());
        } while (!Arrays.equals(startPath, DFSUtilClient.EMPTY_BYTES) || index != -1);
        SnapshotDiffReportGenerator snapshotDiffReport = new SnapshotDiffReportGenerator(snapshotDir, fromSnapshot, toSnapshot, report.getIsFromEarlier(), modifiedList, (List<SnapshotDiffReportListing.DiffReportListingEntry>)createdList, (List<SnapshotDiffReportListing.DiffReportListingEntry>)deletedList);
        return snapshotDiffReport.generateReport();
    }

    public SnapshotDiffReport getSnapshotDiffReport(final Path snapshotDir, final String fromSnapshot, final String toSnapshot) throws IOException {
        Path absF = this.fixRelativePart(snapshotDir);
        return (SnapshotDiffReport)new FileSystemLinkResolver<SnapshotDiffReport>(){

            public SnapshotDiffReport doCall(Path p) throws IOException {
                return DistributedFileSystem.this.getSnapshotDiffReportInternal(DistributedFileSystem.this.getPathName(p), fromSnapshot, toSnapshot);
            }

            public SnapshotDiffReport next(FileSystem fs, Path p) throws IOException {
                if (!(fs instanceof DistributedFileSystem)) {
                    throw new UnsupportedOperationException("Cannot perform snapshot operations on a symlink to a non-DistributedFileSystem: " + snapshotDir + " -> " + p);
                }
                DistributedFileSystem myDfs = (DistributedFileSystem)fs;
                myDfs.getSnapshotDiffReport(p, fromSnapshot, toSnapshot);
                return null;
            }
        }.resolve((FileSystem)this, absF);
    }

    public boolean isFileClosed(final Path src) throws IOException {
        Path absF = this.fixRelativePart(src);
        return (Boolean)new FileSystemLinkResolver<Boolean>(){

            public Boolean doCall(Path p) throws IOException {
                return DistributedFileSystem.this.dfs.isFileClosed(DistributedFileSystem.this.getPathName(p));
            }

            public Boolean next(FileSystem fs, Path p) throws IOException {
                if (fs instanceof DistributedFileSystem) {
                    DistributedFileSystem myDfs = (DistributedFileSystem)fs;
                    return myDfs.isFileClosed(p);
                }
                throw new UnsupportedOperationException("Cannot call isFileClosed on a symlink to a non-DistributedFileSystem: " + src + " -> " + p);
            }
        }.resolve((FileSystem)this, absF);
    }

    public long addCacheDirective(CacheDirectiveInfo info) throws IOException {
        return this.addCacheDirective(info, EnumSet.noneOf(CacheFlag.class));
    }

    public long addCacheDirective(CacheDirectiveInfo info, EnumSet<CacheFlag> flags) throws IOException {
        Preconditions.checkNotNull((Object)info.getPath());
        Path path = new Path(this.getPathName(this.fixRelativePart(info.getPath()))).makeQualified(this.getUri(), this.getWorkingDirectory());
        return this.dfs.addCacheDirective(new CacheDirectiveInfo.Builder(info).setPath(path).build(), flags);
    }

    public void modifyCacheDirective(CacheDirectiveInfo info) throws IOException {
        this.modifyCacheDirective(info, EnumSet.noneOf(CacheFlag.class));
    }

    public void modifyCacheDirective(CacheDirectiveInfo info, EnumSet<CacheFlag> flags) throws IOException {
        if (info.getPath() != null) {
            info = new CacheDirectiveInfo.Builder(info).setPath(new Path(this.getPathName(this.fixRelativePart(info.getPath()))).makeQualified(this.getUri(), this.getWorkingDirectory())).build();
        }
        this.dfs.modifyCacheDirective(info, flags);
    }

    public void removeCacheDirective(long id) throws IOException {
        this.dfs.removeCacheDirective(id);
    }

    public RemoteIterator<CacheDirectiveEntry> listCacheDirectives(CacheDirectiveInfo filter) throws IOException {
        if (filter == null) {
            filter = new CacheDirectiveInfo.Builder().build();
        }
        if (filter.getPath() != null) {
            filter = new CacheDirectiveInfo.Builder(filter).setPath(new Path(this.getPathName(this.fixRelativePart(filter.getPath())))).build();
        }
        final RemoteIterator<CacheDirectiveEntry> iter = this.dfs.listCacheDirectives(filter);
        return new RemoteIterator<CacheDirectiveEntry>(){

            public boolean hasNext() throws IOException {
                return iter.hasNext();
            }

            public CacheDirectiveEntry next() throws IOException {
                CacheDirectiveEntry desc = (CacheDirectiveEntry)iter.next();
                CacheDirectiveInfo info = desc.getInfo();
                Path p = info.getPath().makeQualified(DistributedFileSystem.this.getUri(), DistributedFileSystem.this.getWorkingDirectory());
                return new CacheDirectiveEntry(new CacheDirectiveInfo.Builder(info).setPath(p).build(), desc.getStats());
            }
        };
    }

    public void addCachePool(CachePoolInfo info) throws IOException {
        CachePoolInfo.validate(info);
        this.dfs.addCachePool(info);
    }

    public void modifyCachePool(CachePoolInfo info) throws IOException {
        CachePoolInfo.validate(info);
        this.dfs.modifyCachePool(info);
    }

    public void removeCachePool(String poolName) throws IOException {
        CachePoolInfo.validateName(poolName);
        this.dfs.removeCachePool(poolName);
    }

    public RemoteIterator<CachePoolEntry> listCachePools() throws IOException {
        return this.dfs.listCachePools();
    }

    public void modifyAclEntries(Path path, final List<AclEntry> aclSpec) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.MODIFY_ACL_ENTRIES);
        Path absF = this.fixRelativePart(path);
        new FileSystemLinkResolver<Void>(){

            public Void doCall(Path p) throws IOException {
                DistributedFileSystem.this.dfs.modifyAclEntries(DistributedFileSystem.this.getPathName(p), aclSpec);
                return null;
            }

            public Void next(FileSystem fs, Path p) throws IOException {
                fs.modifyAclEntries(p, aclSpec);
                return null;
            }
        }.resolve((FileSystem)this, absF);
    }

    public void removeAclEntries(Path path, final List<AclEntry> aclSpec) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.REMOVE_ACL_ENTRIES);
        Path absF = this.fixRelativePart(path);
        new FileSystemLinkResolver<Void>(){

            public Void doCall(Path p) throws IOException {
                DistributedFileSystem.this.dfs.removeAclEntries(DistributedFileSystem.this.getPathName(p), aclSpec);
                return null;
            }

            public Void next(FileSystem fs, Path p) throws IOException {
                fs.removeAclEntries(p, aclSpec);
                return null;
            }
        }.resolve((FileSystem)this, absF);
    }

    public void removeDefaultAcl(Path path) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.REMOVE_DEFAULT_ACL);
        Path absF = this.fixRelativePart(path);
        new FileSystemLinkResolver<Void>(){

            public Void doCall(Path p) throws IOException {
                DistributedFileSystem.this.dfs.removeDefaultAcl(DistributedFileSystem.this.getPathName(p));
                return null;
            }

            public Void next(FileSystem fs, Path p) throws IOException {
                fs.removeDefaultAcl(p);
                return null;
            }
        }.resolve((FileSystem)this, absF);
    }

    public void removeAcl(Path path) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.REMOVE_ACL);
        Path absF = this.fixRelativePart(path);
        new FileSystemLinkResolver<Void>(){

            public Void doCall(Path p) throws IOException {
                DistributedFileSystem.this.dfs.removeAcl(DistributedFileSystem.this.getPathName(p));
                return null;
            }

            public Void next(FileSystem fs, Path p) throws IOException {
                fs.removeAcl(p);
                return null;
            }
        }.resolve((FileSystem)this, absF);
    }

    public void setAcl(Path path, final List<AclEntry> aclSpec) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.SET_ACL);
        Path absF = this.fixRelativePart(path);
        new FileSystemLinkResolver<Void>(){

            public Void doCall(Path p) throws IOException {
                DistributedFileSystem.this.dfs.setAcl(DistributedFileSystem.this.getPathName(p), aclSpec);
                return null;
            }

            public Void next(FileSystem fs, Path p) throws IOException {
                fs.setAcl(p, aclSpec);
                return null;
            }
        }.resolve((FileSystem)this, absF);
    }

    public AclStatus getAclStatus(Path path) throws IOException {
        Path absF = this.fixRelativePart(path);
        return (AclStatus)new FileSystemLinkResolver<AclStatus>(){

            public AclStatus doCall(Path p) throws IOException {
                return DistributedFileSystem.this.dfs.getAclStatus(DistributedFileSystem.this.getPathName(p));
            }

            public AclStatus next(FileSystem fs, Path p) throws IOException {
                return fs.getAclStatus(p);
            }
        }.resolve((FileSystem)this, absF);
    }

    public void createEncryptionZone(final Path path, final String keyName) throws IOException {
        Path absF = this.fixRelativePart(path);
        new FileSystemLinkResolver<Void>(){

            public Void doCall(Path p) throws IOException {
                DistributedFileSystem.this.dfs.createEncryptionZone(DistributedFileSystem.this.getPathName(p), keyName);
                return null;
            }

            public Void next(FileSystem fs, Path p) throws IOException {
                if (fs instanceof DistributedFileSystem) {
                    DistributedFileSystem myDfs = (DistributedFileSystem)fs;
                    myDfs.createEncryptionZone(p, keyName);
                    return null;
                }
                throw new UnsupportedOperationException("Cannot call createEncryptionZone on a symlink to a non-DistributedFileSystem: " + path + " -> " + p);
            }
        }.resolve((FileSystem)this, absF);
    }

    public EncryptionZone getEZForPath(final Path path) throws IOException {
        Preconditions.checkNotNull((Object)path);
        Path absF = this.fixRelativePart(path);
        return (EncryptionZone)new FileSystemLinkResolver<EncryptionZone>(){

            public EncryptionZone doCall(Path p) throws IOException {
                return DistributedFileSystem.this.dfs.getEZForPath(DistributedFileSystem.this.getPathName(p));
            }

            public EncryptionZone next(FileSystem fs, Path p) throws IOException {
                if (fs instanceof DistributedFileSystem) {
                    DistributedFileSystem myDfs = (DistributedFileSystem)fs;
                    return myDfs.getEZForPath(p);
                }
                throw new UnsupportedOperationException("Cannot call getEZForPath on a symlink to a non-DistributedFileSystem: " + path + " -> " + p);
            }
        }.resolve((FileSystem)this, absF);
    }

    public RemoteIterator<EncryptionZone> listEncryptionZones() throws IOException {
        return this.dfs.listEncryptionZones();
    }

    public void reencryptEncryptionZone(final Path zone, final HdfsConstants.ReencryptAction action) throws IOException {
        Path absF = this.fixRelativePart(zone);
        new FileSystemLinkResolver<Void>(){

            public Void doCall(Path p) throws IOException {
                DistributedFileSystem.this.dfs.reencryptEncryptionZone(DistributedFileSystem.this.getPathName(p), action);
                return null;
            }

            public Void next(FileSystem fs, Path p) throws IOException {
                if (fs instanceof DistributedFileSystem) {
                    DistributedFileSystem myDfs = (DistributedFileSystem)fs;
                    myDfs.reencryptEncryptionZone(p, action);
                    return null;
                }
                throw new UnsupportedOperationException("Cannot call reencryptEncryptionZone on a symlink to a non-DistributedFileSystem: " + zone + " -> " + p);
            }
        }.resolve((FileSystem)this, absF);
    }

    public RemoteIterator<ZoneReencryptionStatus> listReencryptionStatus() throws IOException {
        return this.dfs.listReencryptionStatus();
    }

    public FileEncryptionInfo getFileEncryptionInfo(final Path path) throws IOException {
        Path absF = this.fixRelativePart(path);
        return (FileEncryptionInfo)new FileSystemLinkResolver<FileEncryptionInfo>(){

            public FileEncryptionInfo doCall(Path p) throws IOException {
                HdfsFileStatus fi = DistributedFileSystem.this.dfs.getFileInfo(DistributedFileSystem.this.getPathName(p));
                if (fi == null) {
                    throw new FileNotFoundException("File does not exist: " + p);
                }
                return fi.getFileEncryptionInfo();
            }

            public FileEncryptionInfo next(FileSystem fs, Path p) throws IOException {
                if (fs instanceof DistributedFileSystem) {
                    DistributedFileSystem myDfs = (DistributedFileSystem)fs;
                    return myDfs.getFileEncryptionInfo(p);
                }
                throw new UnsupportedOperationException("Cannot call getFileEncryptionInfo on a symlink to a non-DistributedFileSystem: " + path + " -> " + p);
            }
        }.resolve((FileSystem)this, absF);
    }

    public void provisionEZTrash(Path path, final FsPermission trashPermission) throws IOException {
        Path absF = this.fixRelativePart(path);
        new FileSystemLinkResolver<Void>(){

            public Void doCall(Path p) throws IOException {
                DistributedFileSystem.this.provisionEZTrash(DistributedFileSystem.this.getPathName(p), trashPermission);
                return null;
            }

            public Void next(FileSystem fs, Path p) throws IOException {
                if (fs instanceof DistributedFileSystem) {
                    DistributedFileSystem myDfs = (DistributedFileSystem)fs;
                    myDfs.provisionEZTrash(p, trashPermission);
                    return null;
                }
                throw new UnsupportedOperationException("Cannot provisionEZTrash through a symlink to a non-DistributedFileSystem: " + fs + " -> " + p);
            }
        }.resolve((FileSystem)this, absF);
    }

    private void provisionEZTrash(String path, FsPermission trashPermission) throws IOException {
        EncryptionZone ez = this.dfs.getEZForPath(path);
        if (ez == null) {
            throw new IllegalArgumentException(path + " is not an encryption zone.");
        }
        String ezPath = ez.getPath();
        if (!path.toString().equals(ezPath)) {
            throw new IllegalArgumentException(path + " is not the root of an encryption zone. Do you mean " + ez.getPath() + "?");
        }
        Path trashPath = new Path(ez.getPath(), ".Trash");
        try {
            FileStatus trashFileStatus = this.getFileStatus(trashPath);
            String errMessage = "Will not provision new trash directory for encryption zone " + ez.getPath() + ". Path already exists.";
            if (!trashFileStatus.isDirectory()) {
                errMessage = errMessage + "\r\nWarning: " + trashPath.toString() + " is not a directory";
            }
            if (!trashFileStatus.getPermission().equals((Object)trashPermission)) {
                errMessage = errMessage + "\r\nWarning: the permission of " + trashPath.toString() + " is not " + trashPermission;
            }
            throw new FileAlreadyExistsException(errMessage);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.mkdir(trashPath, trashPermission);
            this.setPermission(trashPath, trashPermission);
            return;
        }
    }

    public void setXAttr(Path path, final String name, final byte[] value, final EnumSet<XAttrSetFlag> flag) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.SET_XATTR);
        Path absF = this.fixRelativePart(path);
        new FileSystemLinkResolver<Void>(){

            public Void doCall(Path p) throws IOException {
                DistributedFileSystem.this.dfs.setXAttr(DistributedFileSystem.this.getPathName(p), name, value, flag);
                return null;
            }

            public Void next(FileSystem fs, Path p) throws IOException {
                fs.setXAttr(p, name, value, flag);
                return null;
            }
        }.resolve((FileSystem)this, absF);
    }

    public byte[] getXAttr(Path path, final String name) throws IOException {
        this.statistics.incrementReadOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.GET_XATTR);
        Path absF = this.fixRelativePart(path);
        return (byte[])new FileSystemLinkResolver<byte[]>(){

            public byte[] doCall(Path p) throws IOException {
                return DistributedFileSystem.this.dfs.getXAttr(DistributedFileSystem.this.getPathName(p), name);
            }

            public byte[] next(FileSystem fs, Path p) throws IOException {
                return fs.getXAttr(p, name);
            }
        }.resolve((FileSystem)this, absF);
    }

    public Map<String, byte[]> getXAttrs(Path path) throws IOException {
        Path absF = this.fixRelativePart(path);
        return (Map)new FileSystemLinkResolver<Map<String, byte[]>>(){

            public Map<String, byte[]> doCall(Path p) throws IOException {
                return DistributedFileSystem.this.dfs.getXAttrs(DistributedFileSystem.this.getPathName(p));
            }

            public Map<String, byte[]> next(FileSystem fs, Path p) throws IOException {
                return fs.getXAttrs(p);
            }
        }.resolve((FileSystem)this, absF);
    }

    public Map<String, byte[]> getXAttrs(Path path, final List<String> names) throws IOException {
        Path absF = this.fixRelativePart(path);
        return (Map)new FileSystemLinkResolver<Map<String, byte[]>>(){

            public Map<String, byte[]> doCall(Path p) throws IOException {
                return DistributedFileSystem.this.dfs.getXAttrs(DistributedFileSystem.this.getPathName(p), names);
            }

            public Map<String, byte[]> next(FileSystem fs, Path p) throws IOException {
                return fs.getXAttrs(p, names);
            }
        }.resolve((FileSystem)this, absF);
    }

    public List<String> listXAttrs(Path path) throws IOException {
        Path absF = this.fixRelativePart(path);
        return (List)new FileSystemLinkResolver<List<String>>(){

            public List<String> doCall(Path p) throws IOException {
                return DistributedFileSystem.this.dfs.listXAttrs(DistributedFileSystem.this.getPathName(p));
            }

            public List<String> next(FileSystem fs, Path p) throws IOException {
                return fs.listXAttrs(p);
            }
        }.resolve((FileSystem)this, absF);
    }

    public void removeXAttr(Path path, final String name) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.REMOVE_XATTR);
        Path absF = this.fixRelativePart(path);
        new FileSystemLinkResolver<Void>(){

            public Void doCall(Path p) throws IOException {
                DistributedFileSystem.this.dfs.removeXAttr(DistributedFileSystem.this.getPathName(p), name);
                return null;
            }

            public Void next(FileSystem fs, Path p) throws IOException {
                fs.removeXAttr(p, name);
                return null;
            }
        }.resolve((FileSystem)this, absF);
    }

    public void access(Path path, final FsAction mode) throws IOException {
        Path absF = this.fixRelativePart(path);
        new FileSystemLinkResolver<Void>(){

            public Void doCall(Path p) throws IOException {
                DistributedFileSystem.this.dfs.checkAccess(DistributedFileSystem.this.getPathName(p), mode);
                return null;
            }

            public Void next(FileSystem fs, Path p) throws IOException {
                fs.access(p, mode);
                return null;
            }
        }.resolve((FileSystem)this, absF);
    }

    public URI getKeyProviderUri() throws IOException {
        return this.dfs.getKeyProviderUri();
    }

    public KeyProvider getKeyProvider() throws IOException {
        return this.dfs.getKeyProvider();
    }

    public DelegationTokenIssuer[] getAdditionalTokenIssuers() throws IOException {
        KeyProvider keyProvider = this.getKeyProvider();
        if (keyProvider instanceof DelegationTokenIssuer) {
            return new DelegationTokenIssuer[]{(DelegationTokenIssuer)keyProvider};
        }
        return null;
    }

    public DFSInotifyEventInputStream getInotifyEventStream() throws IOException {
        return this.dfs.getInotifyEventStream();
    }

    public DFSInotifyEventInputStream getInotifyEventStream(long lastReadTxid) throws IOException {
        return this.dfs.getInotifyEventStream(lastReadTxid);
    }

    public void setErasureCodingPolicy(final Path path, final String ecPolicyName) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.SET_EC_POLICY);
        Path absF = this.fixRelativePart(path);
        new FileSystemLinkResolver<Void>(){

            public Void doCall(Path p) throws IOException {
                DistributedFileSystem.this.dfs.setErasureCodingPolicy(DistributedFileSystem.this.getPathName(p), ecPolicyName);
                return null;
            }

            public Void next(FileSystem fs, Path p) throws IOException {
                if (fs instanceof DistributedFileSystem) {
                    DistributedFileSystem myDfs = (DistributedFileSystem)fs;
                    myDfs.setErasureCodingPolicy(p, ecPolicyName);
                    return null;
                }
                throw new UnsupportedOperationException("Cannot setErasureCodingPolicy through a symlink to a non-DistributedFileSystem: " + path + " -> " + p);
            }
        }.resolve((FileSystem)this, absF);
    }

    public void satisfyStoragePolicy(final Path path) throws IOException {
        Path absF = this.fixRelativePart(path);
        new FileSystemLinkResolver<Void>(){

            public Void doCall(Path p) throws IOException {
                DistributedFileSystem.this.dfs.satisfyStoragePolicy(DistributedFileSystem.this.getPathName(p));
                return null;
            }

            public Void next(FileSystem fs, Path p) throws IOException {
                if (fs instanceof DistributedFileSystem) {
                    DistributedFileSystem myDfs = (DistributedFileSystem)fs;
                    myDfs.satisfyStoragePolicy(p);
                    return null;
                }
                throw new UnsupportedOperationException("Cannot satisfyStoragePolicy through a symlink to a non-DistributedFileSystem: " + path + " -> " + p);
            }
        }.resolve((FileSystem)this, absF);
    }

    public ErasureCodingPolicy getErasureCodingPolicy(final Path path) throws IOException {
        this.statistics.incrementReadOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.GET_EC_POLICY);
        Path absF = this.fixRelativePart(path);
        return (ErasureCodingPolicy)new FileSystemLinkResolver<ErasureCodingPolicy>(){

            public ErasureCodingPolicy doCall(Path p) throws IOException {
                return DistributedFileSystem.this.dfs.getErasureCodingPolicy(DistributedFileSystem.this.getPathName(p));
            }

            public ErasureCodingPolicy next(FileSystem fs, Path p) throws IOException {
                if (fs instanceof DistributedFileSystem) {
                    DistributedFileSystem myDfs = (DistributedFileSystem)fs;
                    return myDfs.getErasureCodingPolicy(p);
                }
                throw new UnsupportedOperationException("Cannot getErasureCodingPolicy through a symlink to a non-DistributedFileSystem: " + path + " -> " + p);
            }
        }.resolve((FileSystem)this, absF);
    }

    public Collection<ErasureCodingPolicyInfo> getAllErasureCodingPolicies() throws IOException {
        this.statistics.incrementReadOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.GET_EC_POLICIES);
        return Arrays.asList(this.dfs.getErasureCodingPolicies());
    }

    public Map<String, String> getAllErasureCodingCodecs() throws IOException {
        this.statistics.incrementReadOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.GET_EC_CODECS);
        return this.dfs.getErasureCodingCodecs();
    }

    public AddErasureCodingPolicyResponse[] addErasureCodingPolicies(ErasureCodingPolicy[] policies) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.ADD_EC_POLICY);
        return this.dfs.addErasureCodingPolicies(policies);
    }

    public void removeErasureCodingPolicy(String ecPolicyName) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.REMOVE_EC_POLICY);
        this.dfs.removeErasureCodingPolicy(ecPolicyName);
    }

    public void enableErasureCodingPolicy(String ecPolicyName) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.ENABLE_EC_POLICY);
        this.dfs.enableErasureCodingPolicy(ecPolicyName);
    }

    public void disableErasureCodingPolicy(String ecPolicyName) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.DISABLE_EC_POLICY);
        this.dfs.disableErasureCodingPolicy(ecPolicyName);
    }

    public void unsetErasureCodingPolicy(final Path path) throws IOException {
        this.statistics.incrementWriteOps(1);
        this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.UNSET_EC_POLICY);
        Path absF = this.fixRelativePart(path);
        new FileSystemLinkResolver<Void>(){

            public Void doCall(Path p) throws IOException {
                DistributedFileSystem.this.dfs.unsetErasureCodingPolicy(DistributedFileSystem.this.getPathName(p));
                return null;
            }

            public Void next(FileSystem fs, Path p) throws IOException {
                if (fs instanceof DistributedFileSystem) {
                    DistributedFileSystem myDfs = (DistributedFileSystem)fs;
                    myDfs.unsetErasureCodingPolicy(p);
                    return null;
                }
                throw new UnsupportedOperationException("Cannot unsetErasureCodingPolicy through a symlink to a non-DistributedFileSystem: " + path + " -> " + p);
            }
        }.resolve((FileSystem)this, absF);
    }

    public Path getTrashRoot(Path path) {
        try {
            if (path == null || !this.dfs.isHDFSEncryptionEnabled()) {
                return super.getTrashRoot(path);
            }
        }
        catch (IOException ioe) {
            DFSClient.LOG.warn("Exception while checking whether encryption zone is supported", (Throwable)ioe);
        }
        String parentSrc = path.isRoot() ? path.toUri().getPath() : path.getParent().toUri().getPath();
        try {
            EncryptionZone ez = this.dfs.getEZForPath(parentSrc);
            if (ez != null) {
                return this.makeQualified(new Path(new Path(ez.getPath(), ".Trash"), this.dfs.ugi.getShortUserName()));
            }
        }
        catch (IOException e) {
            DFSClient.LOG.warn("Exception in checking the encryption zone for the path " + parentSrc + ". " + e.getMessage());
        }
        return super.getTrashRoot(path);
    }

    public Collection<FileStatus> getTrashRoots(boolean allUsers) {
        ArrayList<FileStatus> ret = new ArrayList<FileStatus>();
        ret.addAll(super.getTrashRoots(allUsers));
        try {
            RemoteIterator<EncryptionZone> it = this.dfs.listEncryptionZones();
            while (it.hasNext()) {
                Path ezTrashRoot = new Path(((EncryptionZone)it.next()).getPath(), ".Trash");
                if (!this.exists(ezTrashRoot)) continue;
                if (allUsers) {
                    for (FileStatus candidate : this.listStatus(ezTrashRoot)) {
                        if (!this.exists(candidate.getPath())) continue;
                        ret.add(candidate);
                    }
                    continue;
                }
                Path userTrash = new Path(ezTrashRoot, this.dfs.ugi.getShortUserName());
                try {
                    ret.add(this.getFileStatus(userTrash));
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
            }
        }
        catch (IOException e) {
            DFSClient.LOG.warn("Cannot get all encrypted trash roots", (Throwable)e);
        }
        return ret;
    }

    protected Path fixRelativePart(Path p) {
        return super.fixRelativePart(p);
    }

    FileSystem.Statistics getFsStatistics() {
        return this.statistics;
    }

    DFSOpsCountStatistics getDFSOpsCountStatistics() {
        return this.storageStatistics;
    }

    public HdfsDataOutputStreamBuilder createFile(Path path) {
        return (HdfsDataOutputStreamBuilder)((HdfsDataOutputStreamBuilder)new HdfsDataOutputStreamBuilder(this, path).create()).overwrite(true);
    }

    @Deprecated
    public RemoteIterator<OpenFileEntry> listOpenFiles() throws IOException {
        return this.dfs.listOpenFiles();
    }

    @Deprecated
    public RemoteIterator<OpenFileEntry> listOpenFiles(EnumSet<OpenFilesIterator.OpenFilesType> openFilesTypes) throws IOException {
        return this.dfs.listOpenFiles(openFilesTypes);
    }

    public RemoteIterator<OpenFileEntry> listOpenFiles(EnumSet<OpenFilesIterator.OpenFilesType> openFilesTypes, String path) throws IOException {
        return this.dfs.listOpenFiles(openFilesTypes, path);
    }

    public HdfsDataOutputStreamBuilder appendFile(Path path) {
        return (HdfsDataOutputStreamBuilder)new HdfsDataOutputStreamBuilder(this, path).append();
    }

    static {
        HdfsConfiguration.init();
    }

    public static final class HdfsDataOutputStreamBuilder
    extends FSDataOutputStreamBuilder<FSDataOutputStream, HdfsDataOutputStreamBuilder> {
        private final DistributedFileSystem dfs;
        private InetSocketAddress[] favoredNodes = null;
        private String ecPolicyName = null;

        private HdfsDataOutputStreamBuilder(DistributedFileSystem dfs, Path path) {
            super((FileSystem)dfs, path);
            this.dfs = dfs;
        }

        protected HdfsDataOutputStreamBuilder getThisBuilder() {
            return this;
        }

        private InetSocketAddress[] getFavoredNodes() {
            return this.favoredNodes;
        }

        public HdfsDataOutputStreamBuilder favoredNodes(@Nonnull InetSocketAddress[] nodes) {
            Preconditions.checkNotNull((Object)nodes);
            this.favoredNodes = (InetSocketAddress[])nodes.clone();
            return this;
        }

        public HdfsDataOutputStreamBuilder syncBlock() {
            this.getFlags().add(CreateFlag.SYNC_BLOCK);
            return this;
        }

        public HdfsDataOutputStreamBuilder lazyPersist() {
            this.getFlags().add(CreateFlag.LAZY_PERSIST);
            return this;
        }

        public HdfsDataOutputStreamBuilder newBlock() {
            this.getFlags().add(CreateFlag.NEW_BLOCK);
            return this;
        }

        public HdfsDataOutputStreamBuilder noLocalWrite() {
            this.getFlags().add(CreateFlag.NO_LOCAL_WRITE);
            return this;
        }

        @VisibleForTesting
        String getEcPolicyName() {
            return this.ecPolicyName;
        }

        public HdfsDataOutputStreamBuilder ecPolicyName(@Nonnull String policyName) {
            Preconditions.checkNotNull((Object)policyName);
            this.ecPolicyName = policyName;
            return this;
        }

        @VisibleForTesting
        boolean shouldReplicate() {
            return this.getFlags().contains(CreateFlag.SHOULD_REPLICATE);
        }

        public HdfsDataOutputStreamBuilder replicate() {
            this.getFlags().add(CreateFlag.SHOULD_REPLICATE);
            return this;
        }

        public HdfsDataOutputStreamBuilder ignoreClientLocality() {
            this.getFlags().add(CreateFlag.IGNORE_CLIENT_LOCALITY);
            return this;
        }

        @VisibleForTesting
        protected EnumSet<CreateFlag> getFlags() {
            return super.getFlags();
        }

        public FSDataOutputStream build() throws IOException {
            if (this.getFlags().contains(CreateFlag.CREATE) || this.getFlags().contains(CreateFlag.OVERWRITE)) {
                if (this.isRecursive()) {
                    return this.dfs.create(this.getPath(), this.getPermission(), this.getFlags(), this.getBufferSize(), this.getReplication(), this.getBlockSize(), this.getProgress(), this.getChecksumOpt(), this.getFavoredNodes(), this.getEcPolicyName());
                }
                return this.dfs.createNonRecursive(this.getPath(), this.getPermission(), this.getFlags(), this.getBufferSize(), this.getReplication(), this.getBlockSize(), this.getProgress(), this.getChecksumOpt(), this.getFavoredNodes(), this.getEcPolicyName());
            }
            if (this.getFlags().contains(CreateFlag.APPEND)) {
                return this.dfs.append(this.getPath(), this.getFlags(), this.getBufferSize(), this.getProgress(), this.getFavoredNodes());
            }
            throw new HadoopIllegalArgumentException("Must specify either create or append");
        }
    }

    private final class SnapshotDiffReportListingIterator
    implements RemoteIterator<SnapshotDiffReportListing> {
        private final String snapshotDir;
        private final String fromSnapshot;
        private final String toSnapshot;
        private byte[] startPath;
        private int index;
        private boolean hasNext = true;

        private SnapshotDiffReportListingIterator(String snapshotDir, String fromSnapshot, String toSnapshot) {
            this.snapshotDir = snapshotDir;
            this.fromSnapshot = fromSnapshot;
            this.toSnapshot = toSnapshot;
            this.startPath = DFSUtilClient.EMPTY_BYTES;
            this.index = -1;
        }

        public boolean hasNext() {
            return this.hasNext;
        }

        public SnapshotDiffReportListing next() throws IOException {
            if (!this.hasNext) {
                throw new NoSuchElementException("No more entry in SnapshotDiffReport for " + this.snapshotDir);
            }
            SnapshotDiffReportListing part = DistributedFileSystem.this.dfs.getSnapshotDiffReportListing(this.snapshotDir, this.fromSnapshot, this.toSnapshot, this.startPath, this.index);
            this.startPath = part.getLastPath();
            this.index = part.getLastIndex();
            this.hasNext = !Arrays.equals(this.startPath, DFSUtilClient.EMPTY_BYTES) || this.index != -1;
            return part;
        }
    }

    private class DirListingIterator<T extends FileStatus>
    implements RemoteIterator<T> {
        private DirectoryListing thisListing;
        private int i;
        private Path p;
        private String src;
        private T curStat = null;
        private PathFilter filter;
        private boolean needLocation;

        private DirListingIterator(Path p, PathFilter filter, boolean needLocation) throws IOException {
            this.p = p;
            this.src = DistributedFileSystem.this.getPathName(p);
            this.filter = filter;
            this.needLocation = needLocation;
            this.thisListing = DistributedFileSystem.this.dfs.listPaths(this.src, HdfsFileStatus.EMPTY_NAME, needLocation);
            DistributedFileSystem.this.statistics.incrementReadOps(1);
            if (needLocation) {
                DistributedFileSystem.this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.LIST_LOCATED_STATUS);
            } else {
                DistributedFileSystem.this.storageStatistics.incrementOpCounter(DFSOpsCountStatistics.OpType.LIST_STATUS);
            }
            if (this.thisListing == null) {
                throw new FileNotFoundException("File " + p + " does not exist.");
            }
            this.i = 0;
        }

        private DirListingIterator(Path p, boolean needLocation) throws IOException {
            this(p, null, needLocation);
        }

        public boolean hasNext() throws IOException {
            while (this.curStat == null && this.hasNextNoFilter()) {
                HdfsFileStatus fileStat = this.thisListing.getPartialListing()[this.i++];
                Object next = this.needLocation ? ((HdfsLocatedFileStatus)fileStat).makeQualifiedLocated(DistributedFileSystem.this.getUri(), this.p) : fileStat.makeQualified(DistributedFileSystem.this.getUri(), this.p);
                if (this.filter != null && !this.filter.accept(next.getPath())) continue;
                this.curStat = next;
            }
            return this.curStat != null;
        }

        private boolean hasNextNoFilter() throws IOException {
            if (this.thisListing == null) {
                return false;
            }
            if (this.i >= this.thisListing.getPartialListing().length && this.thisListing.hasMore()) {
                this.thisListing = DistributedFileSystem.this.dfs.listPaths(this.src, this.thisListing.getLastName(), this.needLocation);
                DistributedFileSystem.this.statistics.incrementReadOps(1);
                if (this.thisListing == null) {
                    throw new FileNotFoundException("File " + this.p + " does not exist.");
                }
                this.i = 0;
            }
            return this.i < this.thisListing.getPartialListing().length;
        }

        public T next() throws IOException {
            if (this.hasNext()) {
                T tmp = this.curStat;
                this.curStat = null;
                return tmp;
            }
            throw new NoSuchElementException("No more entry in " + this.p);
        }
    }
}

