/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.lang3.builder.EqualsBuilder;
import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.lang3.builder.HashCodeBuilder;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.classification.InterfaceAudience;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol.ExtendedBlock;

@InterfaceAudience.Private
public final class ExtendedBlockId {
    private final long blockId;
    private final String bpId;

    public static ExtendedBlockId fromExtendedBlock(ExtendedBlock block) {
        return new ExtendedBlockId(block.getBlockId(), block.getBlockPoolId());
    }

    public ExtendedBlockId(long blockId, String bpId) {
        this.blockId = blockId;
        this.bpId = bpId;
    }

    public long getBlockId() {
        return this.blockId;
    }

    public String getBlockPoolId() {
        return this.bpId;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        ExtendedBlockId other = (ExtendedBlockId)o;
        return new EqualsBuilder().append(this.blockId, other.blockId).append(this.bpId, other.bpId).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.blockId).append(this.bpId).toHashCode();
    }

    public String toString() {
        return String.valueOf(this.blockId) + "_" + this.bpId;
    }
}

