/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs;

import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.classification.InterfaceAudience;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.conf.Configuration;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.DFSUtilClient;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSelector;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.io.Text;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.security.SecurityUtil;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.security.UserGroupInformation;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.security.token.Token;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class HAUtilClient {
    private static final Logger LOG = LoggerFactory.getLogger(HAUtilClient.class);
    private static final DelegationTokenSelector tokenSelector = new DelegationTokenSelector();

    public static boolean isLogicalUri(Configuration conf, URI nameNodeUri) {
        String host = nameNodeUri.getHost();
        return DFSUtilClient.getNameServiceIds(conf).contains(host);
    }

    public static boolean isClientFailoverConfigured(Configuration conf, URI nameNodeUri) {
        String host = nameNodeUri.getHost();
        String configKey = "dfs.client.failover.proxy.provider." + host;
        return conf.get(configKey) != null;
    }

    public static Text buildTokenServiceForLogicalUri(URI uri, String scheme) {
        return new Text(HAUtilClient.buildTokenServicePrefixForLogicalUri(scheme) + uri.getHost());
    }

    public static String buildTokenServicePrefixForLogicalUri(String scheme) {
        return "ha-" + scheme + ":";
    }

    public static URI getServiceUriFromToken(String scheme, Token<?> token) {
        String prefix;
        String tokStr = token.getService().toString();
        if (tokStr.startsWith(prefix = HAUtilClient.buildTokenServicePrefixForLogicalUri(scheme))) {
            tokStr = tokStr.replaceFirst(prefix, "");
        }
        return URI.create(scheme + "://" + tokStr);
    }

    public static boolean isTokenForLogicalUri(Token<?> token) {
        return token.getService().toString().startsWith("ha-");
    }

    public static void cloneDelegationTokenForLogicalUri(UserGroupInformation ugi, URI haUri, Collection<InetSocketAddress> nnAddrs) {
        Text haService = HAUtilClient.buildTokenServiceForLogicalUri(haUri, "hdfs");
        Token haToken = tokenSelector.selectToken(haService, ugi.getTokens());
        if (haToken != null) {
            for (InetSocketAddress singleNNAddr : nnAddrs) {
                Token specificToken = haToken.privateClone(SecurityUtil.buildTokenService((InetSocketAddress)singleNNAddr));
                Text alias = new Text(HAUtilClient.buildTokenServicePrefixForLogicalUri("hdfs") + "//" + specificToken.getService());
                ugi.addToken(alias, specificToken);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Mapped HA service delegation token for logical URI " + haUri + " to namenode " + singleNNAddr);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("No HA service delegation token found for logical URI " + haUri);
        }
    }
}

