/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs;

import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.classification.InterfaceAudience;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.classification.InterfaceStability;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.conf.Configuration;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.crypto.CipherSuite;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.crypto.CryptoCodec;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.crypto.CryptoInputStream;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.crypto.CryptoProtocolVersion;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.crypto.key.KeyProvider;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.crypto.key.KeyProviderCryptoExtension;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.crypto.key.KeyProviderTokenIssuer;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.fs.FileEncryptionInfo;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.DFSUtilClient;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.UnknownCipherSuiteException;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.io.Text;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.security.Credentials;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.security.UserGroupInformation;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.util.KMSUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.GeneralSecurityException;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class HdfsKMSUtil {
    private static final String DFS_KMS_PREFIX = "dfs-kms-";
    private static String keyProviderUriKeyName = "hadoop.security.key.provider.path";

    private HdfsKMSUtil() {
    }

    public static KeyProvider createKeyProvider(Configuration conf) throws IOException {
        return KMSUtil.createKeyProvider((Configuration)conf, (String)keyProviderUriKeyName);
    }

    public static CryptoProtocolVersion getCryptoProtocolVersion(FileEncryptionInfo feInfo) throws IOException {
        CryptoProtocolVersion version = feInfo.getCryptoProtocolVersion();
        if (!CryptoProtocolVersion.supports((CryptoProtocolVersion)version)) {
            throw new IOException("Client does not support specified CryptoProtocolVersion " + version.getDescription() + " version number" + version.getVersion());
        }
        return version;
    }

    public static CryptoCodec getCryptoCodec(Configuration conf, FileEncryptionInfo feInfo) throws IOException {
        CipherSuite suite = feInfo.getCipherSuite();
        if (suite.equals((Object)CipherSuite.UNKNOWN)) {
            throw new IOException("NameNode specified unknown CipherSuite with ID " + suite.getUnknownValue() + ", cannot instantiate CryptoCodec.");
        }
        CryptoCodec codec = CryptoCodec.getInstance((Configuration)conf, (CipherSuite)suite);
        if (codec == null) {
            throw new UnknownCipherSuiteException("No configuration found for the cipher suite " + suite.getConfigSuffix() + " prefixed with " + "hadoop.security.crypto.codec.classes" + ". Please see the example configuration hadoop.security.crypto.codec.classes.EXAMPLECIPHERSUITE at core-default.xml for details.");
        }
        return codec;
    }

    public static URI getKeyProviderUri(UserGroupInformation ugi, URI namenodeUri, String keyProviderUriStr, Configuration conf) throws IOException {
        Text credsKey;
        URI keyProviderUri = null;
        Credentials credentials = ugi.getCredentials();
        byte[] keyProviderUriBytes = credentials.getSecretKey(credsKey = HdfsKMSUtil.getKeyProviderMapKey(namenodeUri));
        if (keyProviderUriBytes != null) {
            keyProviderUri = URI.create(DFSUtilClient.bytes2String(keyProviderUriBytes));
        }
        if (keyProviderUri == null) {
            if (keyProviderUriStr == null) {
                keyProviderUri = KMSUtil.getKeyProviderUri((Configuration)conf, (String)keyProviderUriKeyName);
            } else if (!keyProviderUriStr.isEmpty()) {
                keyProviderUri = URI.create(keyProviderUriStr);
            }
            if (keyProviderUri != null) {
                credentials.addSecretKey(credsKey, DFSUtilClient.string2Bytes(keyProviderUri.toString()));
            }
        }
        return keyProviderUri;
    }

    public static KeyProvider getKeyProvider(KeyProviderTokenIssuer issuer, Configuration conf) throws IOException {
        URI keyProviderUri = issuer.getKeyProviderUri();
        if (keyProviderUri != null) {
            return KMSUtil.createKeyProviderFromUri((Configuration)conf, (URI)keyProviderUri);
        }
        return null;
    }

    public static Text getKeyProviderMapKey(URI namenodeUri) {
        return new Text(DFS_KMS_PREFIX + namenodeUri.getScheme() + "://" + namenodeUri.getAuthority());
    }

    public static CryptoInputStream createWrappedInputStream(InputStream is, KeyProvider keyProvider, FileEncryptionInfo fileEncryptionInfo, Configuration conf) throws IOException {
        HdfsKMSUtil.getCryptoProtocolVersion(fileEncryptionInfo);
        CryptoCodec codec = HdfsKMSUtil.getCryptoCodec(conf, fileEncryptionInfo);
        KeyProvider.KeyVersion decrypted = HdfsKMSUtil.decryptEncryptedDataEncryptionKey(fileEncryptionInfo, keyProvider);
        return new CryptoInputStream(is, codec, decrypted.getMaterial(), fileEncryptionInfo.getIV());
    }

    static KeyProvider.KeyVersion decryptEncryptedDataEncryptionKey(FileEncryptionInfo feInfo, KeyProvider keyProvider) throws IOException {
        if (keyProvider == null) {
            throw new IOException("No KeyProvider is configured, cannot access an encrypted file");
        }
        KeyProviderCryptoExtension.EncryptedKeyVersion ekv = KeyProviderCryptoExtension.EncryptedKeyVersion.createForDecryption((String)feInfo.getKeyName(), (String)feInfo.getEzKeyVersionName(), (byte[])feInfo.getIV(), (byte[])feInfo.getEncryptedDataEncryptionKey());
        try {
            KeyProviderCryptoExtension cryptoProvider = KeyProviderCryptoExtension.createKeyProviderCryptoExtension((KeyProvider)keyProvider);
            return cryptoProvider.decryptEncryptedKey(ekv);
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }
}

