/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs;

import consulting.freiheitsgrade.patched.dependencies.com.google.common.annotations.VisibleForTesting;
import consulting.freiheitsgrade.patched.dependencies.com.google.common.cache.Cache;
import consulting.freiheitsgrade.patched.dependencies.com.google.common.cache.CacheBuilder;
import consulting.freiheitsgrade.patched.dependencies.com.google.common.cache.RemovalListener;
import consulting.freiheitsgrade.patched.dependencies.com.google.common.cache.RemovalNotification;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.classification.InterfaceAudience;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.conf.Configuration;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.crypto.key.KeyProvider;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.util.KMSUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class KeyProviderCache {
    public static final Logger LOG = LoggerFactory.getLogger(KeyProviderCache.class);
    private final Cache<URI, KeyProvider> cache;

    public KeyProviderCache(long expiryMs) {
        this.cache = CacheBuilder.newBuilder().expireAfterAccess(expiryMs, TimeUnit.MILLISECONDS).removalListener((RemovalListener)new RemovalListener<URI, KeyProvider>(){

            public void onRemoval(@Nonnull RemovalNotification<URI, KeyProvider> notification) {
                try {
                    assert (notification.getValue() != null);
                    ((KeyProvider)notification.getValue()).close();
                }
                catch (Throwable e) {
                    LOG.error("Error closing KeyProvider with uri [" + notification.getKey() + "]", e);
                }
            }
        }).build();
    }

    public KeyProvider get(final Configuration conf, final URI serverProviderUri) {
        if (serverProviderUri == null) {
            return null;
        }
        try {
            return (KeyProvider)this.cache.get((Object)serverProviderUri, (Callable)new Callable<KeyProvider>(){

                @Override
                public KeyProvider call() throws Exception {
                    return KMSUtil.createKeyProviderFromUri((Configuration)conf, (URI)serverProviderUri);
                }
            });
        }
        catch (Exception e) {
            LOG.error("Could not create KeyProvider for DFSClient !!", (Throwable)e);
            return null;
        }
    }

    private URI createKeyProviderURI(Configuration conf) {
        URI providerUri;
        String providerUriStr = conf.getTrimmed("hadoop.security.key.provider.path");
        if (providerUriStr == null || providerUriStr.isEmpty()) {
            LOG.error("Could not find uri with key [hadoop.security.key.provider.path] to create a keyProvider !!");
            return null;
        }
        try {
            providerUri = new URI(providerUriStr);
        }
        catch (URISyntaxException e) {
            LOG.error("KeyProvider URI string is invalid [" + providerUriStr + "]!!", e.getCause());
            return null;
        }
        return providerUri;
    }

    @VisibleForTesting
    public void setKeyProvider(Configuration conf, KeyProvider keyProvider) {
        URI uri = this.createKeyProviderURI(conf);
        assert (uri != null);
        this.cache.put((Object)uri, (Object)keyProvider);
    }
}

