/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.client;

import consulting.freiheitsgrade.patched.dependencies.com.google.common.base.Preconditions;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.classification.InterfaceAudience;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.classification.InterfaceStability;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.crypto.CryptoInputStream;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.fs.FSDataInputStream;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.DFSInputStream;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.ReadStatistics;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol.LocatedBlock;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class HdfsDataInputStream
extends FSDataInputStream {
    public HdfsDataInputStream(DFSInputStream in) {
        super((InputStream)((Object)in));
    }

    public HdfsDataInputStream(CryptoInputStream in) {
        super((InputStream)in);
        Preconditions.checkArgument((boolean)(in.getWrappedStream() instanceof DFSInputStream), (Object)"CryptoInputStream should wrap a DFSInputStream");
    }

    private DFSInputStream getDFSInputStream() {
        if (this.in instanceof CryptoInputStream) {
            return (DFSInputStream)((Object)((CryptoInputStream)this.in).getWrappedStream());
        }
        return (DFSInputStream)((Object)this.in);
    }

    public InputStream getWrappedStream() {
        return this.in;
    }

    public DatanodeInfo getCurrentDatanode() {
        return this.getDFSInputStream().getCurrentDatanode();
    }

    public ExtendedBlock getCurrentBlock() {
        return this.getDFSInputStream().getCurrentBlock();
    }

    public List<LocatedBlock> getAllBlocks() throws IOException {
        return this.getDFSInputStream().getAllBlocks();
    }

    public long getVisibleLength() {
        return this.getDFSInputStream().getFileLength();
    }

    public ReadStatistics getReadStatistics() {
        return this.getDFSInputStream().getReadStatistics();
    }

    public void clearReadStatistics() {
        this.getDFSInputStream().clearReadStatistics();
    }
}

