/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.client;

import consulting.freiheitsgrade.patched.dependencies.com.google.common.base.Preconditions;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.classification.InterfaceAudience;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.classification.InterfaceStability;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.crypto.CryptoOutputStream;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.fs.FSDataOutputStream;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.fs.FileSystem;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.DFSOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.EnumSet;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class HdfsDataOutputStream
extends FSDataOutputStream {
    public HdfsDataOutputStream(DFSOutputStream out, FileSystem.Statistics stats, long startPosition) throws IOException {
        super((OutputStream)((Object)out), stats, startPosition);
    }

    public HdfsDataOutputStream(DFSOutputStream out, FileSystem.Statistics stats) throws IOException {
        this(out, stats, 0L);
    }

    public HdfsDataOutputStream(CryptoOutputStream out, FileSystem.Statistics stats, long startPosition) throws IOException {
        super((OutputStream)out, stats, startPosition);
        Preconditions.checkArgument((boolean)(out.getWrappedStream() instanceof DFSOutputStream), (Object)"CryptoOutputStream should wrap a DFSOutputStream");
    }

    public HdfsDataOutputStream(CryptoOutputStream out, FileSystem.Statistics stats) throws IOException {
        this(out, stats, 0L);
    }

    public synchronized int getCurrentBlockReplication() throws IOException {
        OutputStream wrappedStream = this.getWrappedStream();
        if (wrappedStream instanceof CryptoOutputStream) {
            wrappedStream = ((CryptoOutputStream)wrappedStream).getWrappedStream();
        }
        return ((DFSOutputStream)((Object)wrappedStream)).getCurrentBlockReplication();
    }

    public void hsync(EnumSet<SyncFlag> syncFlags) throws IOException {
        OutputStream wrappedStream = this.getWrappedStream();
        if (wrappedStream instanceof CryptoOutputStream) {
            wrappedStream.flush();
            wrappedStream = ((CryptoOutputStream)wrappedStream).getWrappedStream();
        }
        ((DFSOutputStream)((Object)wrappedStream)).hsync(syncFlags);
    }

    public static enum SyncFlag {
        UPDATE_LENGTH,
        END_BLOCK;

    }
}

