/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.inotify;

import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.classification.InterfaceAudience;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.classification.InterfaceStability;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.fs.XAttr;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.fs.permission.AclEntry;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.fs.permission.FsPermission;
import java.util.List;
import java.util.Optional;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public abstract class Event {
    private EventType eventType;

    public EventType getEventType() {
        return this.eventType;
    }

    public Event(EventType eventType) {
        this.eventType = eventType;
    }

    @InterfaceAudience.Public
    public static class TruncateEvent
    extends Event {
        private String path;
        private long fileSize;
        private long timestamp;

        public TruncateEvent(String path, long fileSize, long timestamp) {
            super(EventType.TRUNCATE);
            this.path = path;
            this.fileSize = fileSize;
            this.timestamp = timestamp;
        }

        public String getPath() {
            return this.path;
        }

        public long getFileSize() {
            return this.fileSize;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        @InterfaceStability.Unstable
        public String toString() {
            return "TruncateEvent [path=" + this.path + ", fileSize=" + this.fileSize + ", timestamp=" + this.timestamp + "]";
        }
    }

    @InterfaceAudience.Public
    public static class UnlinkEvent
    extends Event {
        private String path;
        private long timestamp;

        private UnlinkEvent(Builder builder) {
            super(EventType.UNLINK);
            this.path = builder.path;
            this.timestamp = builder.timestamp;
        }

        public String getPath() {
            return this.path;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        @InterfaceStability.Unstable
        public String toString() {
            return "UnlinkEvent [path=" + this.path + ", timestamp=" + this.timestamp + "]";
        }

        public static class Builder {
            private String path;
            private long timestamp;

            public Builder path(String path) {
                this.path = path;
                return this;
            }

            public Builder timestamp(long timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            public UnlinkEvent build() {
                return new UnlinkEvent(this);
            }
        }
    }

    @InterfaceAudience.Public
    public static class AppendEvent
    extends Event {
        private String path;
        private boolean newBlock;

        private AppendEvent(Builder b) {
            super(EventType.APPEND);
            this.path = b.path;
            this.newBlock = b.newBlock;
        }

        public String getPath() {
            return this.path;
        }

        public boolean toNewBlock() {
            return this.newBlock;
        }

        @InterfaceStability.Unstable
        public String toString() {
            return "AppendEvent [path=" + this.path + ", newBlock=" + this.newBlock + "]";
        }

        public static class Builder {
            private String path;
            private boolean newBlock;

            public Builder path(String path) {
                this.path = path;
                return this;
            }

            public Builder newBlock(boolean newBlock) {
                this.newBlock = newBlock;
                return this;
            }

            public AppendEvent build() {
                return new AppendEvent(this);
            }
        }
    }

    @InterfaceAudience.Public
    public static class RenameEvent
    extends Event {
        private String srcPath;
        private String dstPath;
        private long timestamp;

        private RenameEvent(Builder builder) {
            super(EventType.RENAME);
            this.srcPath = builder.srcPath;
            this.dstPath = builder.dstPath;
            this.timestamp = builder.timestamp;
        }

        public String getSrcPath() {
            return this.srcPath;
        }

        public String getDstPath() {
            return this.dstPath;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        @InterfaceStability.Unstable
        public String toString() {
            return "RenameEvent [srcPath=" + this.srcPath + ", dstPath=" + this.dstPath + ", timestamp=" + this.timestamp + "]";
        }

        public static class Builder {
            private String srcPath;
            private String dstPath;
            private long timestamp;

            public Builder srcPath(String srcPath) {
                this.srcPath = srcPath;
                return this;
            }

            public Builder dstPath(String dstPath) {
                this.dstPath = dstPath;
                return this;
            }

            public Builder timestamp(long timestamp) {
                this.timestamp = timestamp;
                return this;
            }

            public RenameEvent build() {
                return new RenameEvent(this);
            }
        }
    }

    @InterfaceAudience.Public
    public static class MetadataUpdateEvent
    extends Event {
        private String path;
        private MetadataType metadataType;
        private long mtime;
        private long atime;
        private int replication;
        private String ownerName;
        private String groupName;
        private FsPermission perms;
        private List<AclEntry> acls;
        private List<XAttr> xAttrs;
        private boolean xAttrsRemoved;

        private MetadataUpdateEvent(Builder b) {
            super(EventType.METADATA);
            this.path = b.path;
            this.metadataType = b.metadataType;
            this.mtime = b.mtime;
            this.atime = b.atime;
            this.replication = b.replication;
            this.ownerName = b.ownerName;
            this.groupName = b.groupName;
            this.perms = b.perms;
            this.acls = b.acls;
            this.xAttrs = b.xAttrs;
            this.xAttrsRemoved = b.xAttrsRemoved;
        }

        public String getPath() {
            return this.path;
        }

        public MetadataType getMetadataType() {
            return this.metadataType;
        }

        public long getMtime() {
            return this.mtime;
        }

        public long getAtime() {
            return this.atime;
        }

        public int getReplication() {
            return this.replication;
        }

        public String getOwnerName() {
            return this.ownerName;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public FsPermission getPerms() {
            return this.perms;
        }

        public List<AclEntry> getAcls() {
            return this.acls;
        }

        public List<XAttr> getxAttrs() {
            return this.xAttrs;
        }

        public boolean isxAttrsRemoved() {
            return this.xAttrsRemoved;
        }

        @InterfaceStability.Unstable
        public String toString() {
            StringBuilder content = new StringBuilder();
            content.append("MetadataUpdateEvent [path=").append(this.path).append(", metadataType=").append((Object)this.metadataType);
            switch (this.metadataType) {
                case TIMES: {
                    content.append(", mtime=").append(this.mtime).append(", atime=").append(this.atime);
                    break;
                }
                case REPLICATION: {
                    content.append(", replication=").append(this.replication);
                    break;
                }
                case OWNER: {
                    content.append(", ownerName=").append(this.ownerName).append(", groupName=").append(this.groupName);
                    break;
                }
                case PERMS: {
                    content.append(", perms=").append(this.perms);
                    break;
                }
                case ACLS: {
                    content.append(", acls=").append(this.acls);
                    break;
                }
                case XATTRS: {
                    content.append(", xAttrs=").append(this.xAttrs).append(", xAttrsRemoved=").append(this.xAttrsRemoved);
                    break;
                }
            }
            content.append(']');
            return content.toString();
        }

        public static class Builder {
            private String path;
            private MetadataType metadataType;
            private long mtime;
            private long atime;
            private int replication;
            private String ownerName;
            private String groupName;
            private FsPermission perms;
            private List<AclEntry> acls;
            private List<XAttr> xAttrs;
            private boolean xAttrsRemoved;

            public Builder path(String path) {
                this.path = path;
                return this;
            }

            public Builder metadataType(MetadataType type) {
                this.metadataType = type;
                return this;
            }

            public Builder mtime(long mtime) {
                this.mtime = mtime;
                return this;
            }

            public Builder atime(long atime) {
                this.atime = atime;
                return this;
            }

            public Builder replication(int replication) {
                this.replication = replication;
                return this;
            }

            public Builder ownerName(String ownerName) {
                this.ownerName = ownerName;
                return this;
            }

            public Builder groupName(String groupName) {
                this.groupName = groupName;
                return this;
            }

            public Builder perms(FsPermission perms) {
                this.perms = perms;
                return this;
            }

            public Builder acls(List<AclEntry> acls) {
                this.acls = acls;
                return this;
            }

            public Builder xAttrs(List<XAttr> xAttrs) {
                this.xAttrs = xAttrs;
                return this;
            }

            public Builder xAttrsRemoved(boolean xAttrsRemoved) {
                this.xAttrsRemoved = xAttrsRemoved;
                return this;
            }

            public MetadataUpdateEvent build() {
                return new MetadataUpdateEvent(this);
            }
        }

        public static enum MetadataType {
            TIMES,
            REPLICATION,
            OWNER,
            PERMS,
            ACLS,
            XATTRS;

        }
    }

    @InterfaceAudience.Public
    public static class CreateEvent
    extends Event {
        private INodeType iNodeType;
        private String path;
        private long ctime;
        private int replication;
        private String ownerName;
        private String groupName;
        private FsPermission perms;
        private String symlinkTarget;
        private boolean overwrite;
        private long defaultBlockSize;
        private Optional<Boolean> erasureCoded;

        private CreateEvent(Builder b) {
            super(EventType.CREATE);
            this.iNodeType = b.iNodeType;
            this.path = b.path;
            this.ctime = b.ctime;
            this.replication = b.replication;
            this.ownerName = b.ownerName;
            this.groupName = b.groupName;
            this.perms = b.perms;
            this.symlinkTarget = b.symlinkTarget;
            this.overwrite = b.overwrite;
            this.defaultBlockSize = b.defaultBlockSize;
            this.erasureCoded = b.erasureCoded;
        }

        public INodeType getiNodeType() {
            return this.iNodeType;
        }

        public String getPath() {
            return this.path;
        }

        public long getCtime() {
            return this.ctime;
        }

        public int getReplication() {
            return this.replication;
        }

        public String getOwnerName() {
            return this.ownerName;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public FsPermission getPerms() {
            return this.perms;
        }

        public String getSymlinkTarget() {
            return this.symlinkTarget;
        }

        public boolean getOverwrite() {
            return this.overwrite;
        }

        public long getDefaultBlockSize() {
            return this.defaultBlockSize;
        }

        public Optional<Boolean> isErasureCoded() {
            return this.erasureCoded;
        }

        @InterfaceStability.Unstable
        public String toString() {
            StringBuilder content = new StringBuilder();
            content.append("CreateEvent [INodeType=").append((Object)this.iNodeType).append(", path=").append(this.path).append(", ctime=").append(this.ctime).append(", replication=").append(this.replication).append(", ownerName=").append(this.ownerName).append(", groupName=").append(this.groupName).append(", perms=").append(this.perms).append(", ");
            if (this.symlinkTarget != null) {
                content.append("symlinkTarget=").append(this.symlinkTarget).append(", ");
            }
            content.append("overwrite=").append(this.overwrite).append(", defaultBlockSize=").append(this.defaultBlockSize).append(", erasureCoded=").append(this.erasureCoded).append("]");
            return content.toString();
        }

        public static class Builder {
            private INodeType iNodeType;
            private String path;
            private long ctime;
            private int replication;
            private String ownerName;
            private String groupName;
            private FsPermission perms;
            private String symlinkTarget;
            private boolean overwrite;
            private long defaultBlockSize = 0L;
            private Optional<Boolean> erasureCoded = Optional.empty();

            public Builder iNodeType(INodeType type) {
                this.iNodeType = type;
                return this;
            }

            public Builder path(String path) {
                this.path = path;
                return this;
            }

            public Builder ctime(long ctime) {
                this.ctime = ctime;
                return this;
            }

            public Builder replication(int replication) {
                this.replication = replication;
                return this;
            }

            public Builder ownerName(String ownerName) {
                this.ownerName = ownerName;
                return this;
            }

            public Builder groupName(String groupName) {
                this.groupName = groupName;
                return this;
            }

            public Builder perms(FsPermission perms) {
                this.perms = perms;
                return this;
            }

            public Builder symlinkTarget(String symlinkTarget) {
                this.symlinkTarget = symlinkTarget;
                return this;
            }

            public Builder overwrite(boolean overwrite) {
                this.overwrite = overwrite;
                return this;
            }

            public Builder defaultBlockSize(long defaultBlockSize) {
                this.defaultBlockSize = defaultBlockSize;
                return this;
            }

            public Builder erasureCoded(boolean ecCoded) {
                this.erasureCoded = Optional.of(ecCoded);
                return this;
            }

            public CreateEvent build() {
                return new CreateEvent(this);
            }
        }

        public static enum INodeType {
            FILE,
            DIRECTORY,
            SYMLINK;

        }
    }

    @InterfaceAudience.Public
    public static class CloseEvent
    extends Event {
        private String path;
        private long fileSize;
        private long timestamp;

        public CloseEvent(String path, long fileSize, long timestamp) {
            super(EventType.CLOSE);
            this.path = path;
            this.fileSize = fileSize;
            this.timestamp = timestamp;
        }

        public String getPath() {
            return this.path;
        }

        public long getFileSize() {
            return this.fileSize;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        @InterfaceStability.Unstable
        public String toString() {
            return "CloseEvent [path=" + this.path + ", fileSize=" + this.fileSize + ", timestamp=" + this.timestamp + "]";
        }
    }

    public static enum EventType {
        CREATE,
        CLOSE,
        APPEND,
        RENAME,
        METADATA,
        UNLINK,
        TRUNCATE;

    }
}

