/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.net;

import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.net.Peer;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.net.SocketInputStream;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.net.SocketOutputStream;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.net.unix.DomainSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class NioInetPeer
implements Peer {
    private final Socket socket;
    private final SocketInputStream in;
    private final SocketOutputStream out;
    private final boolean isLocal;

    public NioInetPeer(Socket socket) throws IOException {
        this.socket = socket;
        this.in = new SocketInputStream((ReadableByteChannel)socket.getChannel(), 0L);
        this.out = new SocketOutputStream((WritableByteChannel)socket.getChannel(), 0L);
        this.isLocal = socket.getInetAddress().equals(socket.getLocalAddress());
    }

    @Override
    public ReadableByteChannel getInputStreamChannel() {
        return this.in;
    }

    @Override
    public void setReadTimeout(int timeoutMs) throws IOException {
        this.in.setTimeout((long)timeoutMs);
    }

    @Override
    public int getReceiveBufferSize() throws IOException {
        return this.socket.getReceiveBufferSize();
    }

    @Override
    public boolean getTcpNoDelay() throws IOException {
        return this.socket.getTcpNoDelay();
    }

    @Override
    public void setWriteTimeout(int timeoutMs) throws IOException {
        this.out.setTimeout(timeoutMs);
    }

    @Override
    public boolean isClosed() {
        return this.socket.isClosed();
    }

    @Override
    public void close() throws IOException {
        try {
            this.in.close();
        }
        finally {
            this.out.close();
        }
    }

    @Override
    public String getRemoteAddressString() {
        SocketAddress address = this.socket.getRemoteSocketAddress();
        return address == null ? null : address.toString();
    }

    @Override
    public String getLocalAddressString() {
        return this.socket.getLocalSocketAddress().toString();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.in;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.out;
    }

    @Override
    public boolean isLocal() {
        return this.isLocal;
    }

    public String toString() {
        return "NioInetPeer(" + this.socket.toString() + ")";
    }

    @Override
    public DomainSocket getDomainSocket() {
        return null;
    }

    @Override
    public boolean hasSecureChannel() {
        return false;
    }
}

