/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol;

import consulting.freiheitsgrade.patched.dependencies.com.google.common.base.Preconditions;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.classification.InterfaceAudience;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.classification.InterfaceStability;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.fs.BatchedRemoteIterator;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.fs.InvalidRequestException;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol.ClientProtocol;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.ipc.RemoteException;
import consulting.freiheitsgrade.patched.dependencies.org.apache.htrace.core.TraceScope;
import consulting.freiheitsgrade.patched.dependencies.org.apache.htrace.core.Tracer;
import java.io.IOException;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class CacheDirectiveIterator
extends BatchedRemoteIterator<Long, CacheDirectiveEntry> {
    private CacheDirectiveInfo filter;
    private final ClientProtocol namenode;
    private final Tracer tracer;

    public CacheDirectiveIterator(ClientProtocol namenode, CacheDirectiveInfo filter, Tracer tracer) {
        super((Object)0L);
        this.namenode = namenode;
        this.filter = filter;
        this.tracer = tracer;
    }

    private static CacheDirectiveInfo removeIdFromFilter(CacheDirectiveInfo filter) {
        CacheDirectiveInfo.Builder builder = new CacheDirectiveInfo.Builder(filter);
        builder.setId(null);
        return builder.build();
    }

    public BatchedRemoteIterator.BatchedEntries<CacheDirectiveEntry> makeRequest(Long prevKey) throws IOException {
        BatchedRemoteIterator.BatchedEntries<CacheDirectiveEntry> entries;
        try (TraceScope ignored = this.tracer.newScope("listCacheDirectives");){
            entries = this.namenode.listCacheDirectives(prevKey, this.filter);
        }
        catch (IOException e) {
            if (e.getMessage().contains("Filtering by ID is unsupported")) {
                long id = this.filter.getId();
                this.filter = CacheDirectiveIterator.removeIdFromFilter(this.filter);
                BatchedRemoteIterator.BatchedEntries<CacheDirectiveEntry> entries2 = this.namenode.listCacheDirectives(id - 1L, this.filter);
                for (int i = 0; i < entries2.size(); ++i) {
                    CacheDirectiveEntry entry = (CacheDirectiveEntry)entries2.get(i);
                    if (!entry.getInfo().getId().equals(id)) continue;
                    return new SingleEntry(entry);
                }
                throw new RemoteException(InvalidRequestException.class.getName(), "Did not find requested id " + id);
            }
            throw e;
        }
        Preconditions.checkNotNull(entries);
        return entries;
    }

    public Long elementToPrevKey(CacheDirectiveEntry entry) {
        return entry.getInfo().getId();
    }

    private static class SingleEntry
    implements BatchedRemoteIterator.BatchedEntries<CacheDirectiveEntry> {
        private final CacheDirectiveEntry entry;

        public SingleEntry(CacheDirectiveEntry entry) {
            this.entry = entry;
        }

        public CacheDirectiveEntry get(int i) {
            if (i > 0) {
                return null;
            }
            return this.entry;
        }

        public int size() {
            return 1;
        }

        public boolean hasMore() {
            return false;
        }
    }
}

