/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol;

import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.classification.InterfaceAudience;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.classification.InterfaceStability;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.fs.BatchedRemoteIterator;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol.ClientProtocol;
import consulting.freiheitsgrade.patched.dependencies.org.apache.htrace.core.TraceScope;
import consulting.freiheitsgrade.patched.dependencies.org.apache.htrace.core.Tracer;
import java.io.IOException;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class CachePoolIterator
extends BatchedRemoteIterator<String, CachePoolEntry> {
    private final ClientProtocol namenode;
    private final Tracer tracer;

    public CachePoolIterator(ClientProtocol namenode, Tracer tracer) {
        super((Object)"");
        this.namenode = namenode;
        this.tracer = tracer;
    }

    public BatchedRemoteIterator.BatchedEntries<CachePoolEntry> makeRequest(String prevKey) throws IOException {
        try (TraceScope ignored = this.tracer.newScope("listCachePools");){
            BatchedRemoteIterator.BatchedEntries<CachePoolEntry> batchedEntries = this.namenode.listCachePools(prevKey);
            return batchedEntries;
        }
    }

    public String elementToPrevKey(CachePoolEntry entry) {
        return entry.getInfo().getPoolName();
    }
}

