/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol;

import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.classification.InterfaceAudience;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.classification.InterfaceStability;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.fs.BatchedRemoteIterator;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol.ClientProtocol;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol.EncryptionZone;
import consulting.freiheitsgrade.patched.dependencies.org.apache.htrace.core.TraceScope;
import consulting.freiheitsgrade.patched.dependencies.org.apache.htrace.core.Tracer;
import java.io.IOException;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class EncryptionZoneIterator
extends BatchedRemoteIterator<Long, EncryptionZone> {
    private final ClientProtocol namenode;
    private final Tracer tracer;

    public EncryptionZoneIterator(ClientProtocol namenode, Tracer tracer) {
        super((Object)0L);
        this.namenode = namenode;
        this.tracer = tracer;
    }

    public BatchedRemoteIterator.BatchedEntries<EncryptionZone> makeRequest(Long prevId) throws IOException {
        try (TraceScope ignored = this.tracer.newScope("listEncryptionZones");){
            BatchedRemoteIterator.BatchedEntries<EncryptionZone> batchedEntries = this.namenode.listEncryptionZones(prevId);
            return batchedEntries;
        }
    }

    public Long elementToPrevKey(EncryptionZone entry) {
        return entry.getId();
    }
}

