/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol;

import consulting.freiheitsgrade.patched.dependencies.org.apache.commons.lang3.builder.HashCodeBuilder;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.classification.InterfaceAudience;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.classification.InterfaceStability;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol.Block;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ExtendedBlock {
    private String poolId;
    private Block block;

    public ExtendedBlock() {
        this(null, 0L, 0L, 0L);
    }

    public ExtendedBlock(ExtendedBlock b) {
        this(b.poolId, new Block(b.block));
    }

    public ExtendedBlock(String poolId, long blockId) {
        this(poolId, blockId, 0L, 0L);
    }

    public ExtendedBlock(String poolId, Block b) {
        this.poolId = poolId != null ? poolId.intern() : null;
        this.block = b;
    }

    public ExtendedBlock(String poolId, long blkid, long len, long genstamp) {
        this.poolId = poolId != null ? poolId.intern() : null;
        this.block = new Block(blkid, len, genstamp);
    }

    public String getBlockPoolId() {
        return this.poolId;
    }

    public String getBlockName() {
        return this.block.getBlockName();
    }

    public long getNumBytes() {
        return this.block.getNumBytes();
    }

    public long getBlockId() {
        return this.block.getBlockId();
    }

    public long getGenerationStamp() {
        return this.block.getGenerationStamp();
    }

    public void setBlockId(long bid) {
        this.block.setBlockId(bid);
    }

    public void setGenerationStamp(long genStamp) {
        this.block.setGenerationStamp(genStamp);
    }

    public void setNumBytes(long len) {
        this.block.setNumBytes(len);
    }

    public void set(String poolId, Block blk) {
        this.poolId = poolId != null ? poolId.intern() : null;
        this.block = blk;
    }

    public static Block getLocalBlock(ExtendedBlock b) {
        return b == null ? null : b.getLocalBlock();
    }

    public Block getLocalBlock() {
        return this.block;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExtendedBlock)) {
            return false;
        }
        ExtendedBlock b = (ExtendedBlock)o;
        return b.block.equals(this.block) && (b.poolId != null ? b.poolId.equals(this.poolId) : this.poolId == null);
    }

    public int hashCode() {
        return new HashCodeBuilder(31, 17).append(this.poolId).append(this.block).toHashCode();
    }

    public String toString() {
        return this.poolId + ":" + this.block;
    }
}

