/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol;

import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.classification.InterfaceAudience;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.classification.InterfaceStability;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.fs.StorageType;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol.LocatedBlock;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.security.token.Token;
import java.util.Arrays;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class LocatedStripedBlock
extends LocatedBlock {
    private static final byte[] EMPTY_INDICES = new byte[0];
    private static final Token<BlockTokenIdentifier> EMPTY_TOKEN = new Token();
    private final byte[] blockIndices;
    private Token<BlockTokenIdentifier>[] blockTokens;

    public LocatedStripedBlock(ExtendedBlock b, DatanodeInfo[] locs, String[] storageIDs, StorageType[] storageTypes, byte[] indices, long startOffset, boolean corrupt, DatanodeInfo[] cachedLocs) {
        super(b, locs, storageIDs, storageTypes, startOffset, corrupt, cachedLocs);
        if (indices == null) {
            this.blockIndices = EMPTY_INDICES;
        } else {
            this.blockIndices = new byte[indices.length];
            System.arraycopy(indices, 0, this.blockIndices, 0, indices.length);
        }
        this.blockTokens = new Token[this.blockIndices.length];
        for (int i = 0; i < this.blockIndices.length; ++i) {
            this.blockTokens[i] = EMPTY_TOKEN;
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.getBlock() + "; getBlockSize()=" + this.getBlockSize() + "; corrupt=" + this.isCorrupt() + "; offset=" + this.getStartOffset() + "; locs=" + Arrays.asList(this.getLocations()) + "; indices=" + Arrays.toString(this.blockIndices) + "}";
    }

    public byte[] getBlockIndices() {
        return this.blockIndices;
    }

    @Override
    public boolean isStriped() {
        return true;
    }

    public Token<BlockTokenIdentifier>[] getBlockTokens() {
        return this.blockTokens;
    }

    public void setBlockTokens(Token<BlockTokenIdentifier>[] tokens) {
        this.blockTokens = tokens;
    }
}

