/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol;

import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.classification.InterfaceAudience;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.classification.InterfaceStability;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.fs.StorageType;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class QuotaByStorageTypeExceededException
extends QuotaExceededException {
    protected static final long serialVersionUID = 1L;
    protected StorageType type;

    public QuotaByStorageTypeExceededException() {
    }

    public QuotaByStorageTypeExceededException(String msg) {
        super(msg);
    }

    public QuotaByStorageTypeExceededException(long quota, long count, StorageType type) {
        super(quota, count);
        this.type = type;
    }

    @Override
    public String getMessage() {
        String msg = super.getMessage();
        if (msg == null) {
            return "Quota by storage type : " + this.type.toString() + " on path : " + (this.pathName == null ? "" : this.pathName) + " is exceeded. quota = " + StringUtils.TraditionalBinaryPrefix.long2String((long)this.quota, (String)"B", (int)2) + " but space consumed = " + StringUtils.TraditionalBinaryPrefix.long2String((long)this.count, (String)"B", (int)2);
        }
        return msg;
    }
}

