/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol;

import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.classification.InterfaceAudience;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.fs.BatchedRemoteIterator;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol.ClientProtocol;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol.ZoneReencryptionStatus;
import consulting.freiheitsgrade.patched.dependencies.org.apache.htrace.core.TraceScope;
import consulting.freiheitsgrade.patched.dependencies.org.apache.htrace.core.Tracer;
import java.io.IOException;

@InterfaceAudience.Private
public class ReencryptionStatusIterator
extends BatchedRemoteIterator<Long, ZoneReencryptionStatus> {
    private final ClientProtocol namenode;
    private final Tracer tracer;

    public ReencryptionStatusIterator(ClientProtocol namenode, Tracer tracer) {
        super((Object)0L);
        this.namenode = namenode;
        this.tracer = tracer;
    }

    public BatchedRemoteIterator.BatchedEntries<ZoneReencryptionStatus> makeRequest(Long prevId) throws IOException {
        try (TraceScope ignored = this.tracer.newScope("listReencryptionStatus");){
            BatchedRemoteIterator.BatchedEntries<ZoneReencryptionStatus> batchedEntries = this.namenode.listReencryptionStatus(prevId);
            return batchedEntries;
        }
    }

    public Long elementToPrevKey(ZoneReencryptionStatus entry) {
        return entry.getId();
    }
}

