/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocolPB;

import consulting.freiheitsgrade.patched.dependencies.com.google.protobuf.RpcController;
import consulting.freiheitsgrade.patched.dependencies.com.google.protobuf.ServiceException;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.classification.InterfaceAudience;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.classification.InterfaceStability;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.conf.Configuration;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.conf.ReconfigurationTaskStatus;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol.ReconfigurationProtocol;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol.proto.ReconfigurationProtocolProtos;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocolPB.ReconfigurationProtocolPB;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocolPB.ReconfigurationProtocolUtils;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.ipc.ProtobufHelper;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.ipc.ProtobufRpcEngine;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.ipc.ProtocolMetaInterface;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.ipc.ProtocolTranslator;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.ipc.RPC;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.ipc.RpcClientUtil;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.security.UserGroupInformation;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import javax.net.SocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class ReconfigurationProtocolTranslatorPB
implements ProtocolMetaInterface,
ReconfigurationProtocol,
ProtocolTranslator,
Closeable {
    public static final Logger LOG = LoggerFactory.getLogger(ReconfigurationProtocolTranslatorPB.class);
    private static final RpcController NULL_CONTROLLER = null;
    private static final ReconfigurationProtocolProtos.StartReconfigurationRequestProto VOID_START_RECONFIG = ReconfigurationProtocolProtos.StartReconfigurationRequestProto.newBuilder().build();
    private static final ReconfigurationProtocolProtos.ListReconfigurablePropertiesRequestProto VOID_LIST_RECONFIGURABLE_PROPERTIES = ReconfigurationProtocolProtos.ListReconfigurablePropertiesRequestProto.newBuilder().build();
    private static final ReconfigurationProtocolProtos.GetReconfigurationStatusRequestProto VOID_GET_RECONFIG_STATUS = ReconfigurationProtocolProtos.GetReconfigurationStatusRequestProto.newBuilder().build();
    private final ReconfigurationProtocolPB rpcProxy;

    public ReconfigurationProtocolTranslatorPB(InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory) throws IOException {
        this.rpcProxy = ReconfigurationProtocolTranslatorPB.createReconfigurationProtocolProxy(addr, ticket, conf, factory, 0);
    }

    static ReconfigurationProtocolPB createReconfigurationProtocolProxy(InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory, int socketTimeout) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, ReconfigurationProtocolPB.class, ProtobufRpcEngine.class);
        return (ReconfigurationProtocolPB)RPC.getProxy(ReconfigurationProtocolPB.class, (long)RPC.getProtocolVersion(ReconfigurationProtocolPB.class), (InetSocketAddress)addr, (UserGroupInformation)ticket, (Configuration)conf, (SocketFactory)factory, (int)socketTimeout);
    }

    @Override
    public void close() throws IOException {
        RPC.stopProxy((Object)this.rpcProxy);
    }

    public Object getUnderlyingProxyObject() {
        return this.rpcProxy;
    }

    @Override
    public void startReconfiguration() throws IOException {
        try {
            this.rpcProxy.startReconfiguration(NULL_CONTROLLER, VOID_START_RECONFIG);
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public ReconfigurationTaskStatus getReconfigurationStatus() throws IOException {
        try {
            return ReconfigurationProtocolUtils.getReconfigurationStatus(this.rpcProxy.getReconfigurationStatus(NULL_CONTROLLER, VOID_GET_RECONFIG_STATUS));
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    @Override
    public List<String> listReconfigurableProperties() throws IOException {
        try {
            ReconfigurationProtocolProtos.ListReconfigurablePropertiesResponseProto response = this.rpcProxy.listReconfigurableProperties(NULL_CONTROLLER, VOID_LIST_RECONFIGURABLE_PROPERTIES);
            return response.getNameList();
        }
        catch (ServiceException e) {
            throw ProtobufHelper.getRemoteException((ServiceException)e);
        }
    }

    public boolean isMethodSupported(String methodName) throws IOException {
        return RpcClientUtil.isMethodSupported((Object)this.rpcProxy, ReconfigurationProtocolPB.class, (RPC.RpcKind)RPC.RpcKind.RPC_PROTOCOL_BUFFER, (long)RPC.getProtocolVersion(ReconfigurationProtocolPB.class), (String)methodName);
    }
}

