/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocolPB;

import consulting.freiheitsgrade.patched.dependencies.com.google.common.collect.Maps;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.conf.ReconfigurationTaskStatus;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.conf.ReconfigurationUtil;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol.proto.ReconfigurationProtocolProtos;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public final class ReconfigurationProtocolUtils {
    private ReconfigurationProtocolUtils() {
    }

    public static ReconfigurationTaskStatus getReconfigurationStatus(ReconfigurationProtocolProtos.GetReconfigurationStatusResponseProto response) {
        HashMap statusMap = null;
        long endTime = 0L;
        long startTime = response.getStartTime();
        if (response.hasEndTime()) {
            endTime = response.getEndTime();
        }
        if (response.getChangesCount() > 0) {
            statusMap = Maps.newHashMap();
            for (ReconfigurationProtocolProtos.GetReconfigurationStatusConfigChangeProto change : response.getChangesList()) {
                ReconfigurationUtil.PropertyChange pc = new ReconfigurationUtil.PropertyChange(change.getName(), change.getNewValue(), change.getOldValue());
                String errorMessage = null;
                if (change.hasErrorMessage()) {
                    errorMessage = change.getErrorMessage();
                }
                statusMap.put(pc, Optional.ofNullable(errorMessage));
            }
        }
        return new ReconfigurationTaskStatus(startTime, endTime, (Map)statusMap);
    }
}

