/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.security.token.delegation;

import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.classification.InterfaceAudience;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.conf.Configuration;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.io.Text;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.net.NetUtils;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.security.SecurityUtil;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.security.token.Token;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSelector;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collection;

@InterfaceAudience.Private
public class DelegationTokenSelector
extends AbstractDelegationTokenSelector<DelegationTokenIdentifier> {
    public static final String SERVICE_NAME_KEY = "hdfs.service.host_";

    public Token<DelegationTokenIdentifier> selectToken(URI nnUri, Collection<Token<?>> tokens, Configuration conf) {
        Text serviceName = SecurityUtil.buildTokenService((URI)nnUri);
        String nnServiceName = conf.get(SERVICE_NAME_KEY + serviceName);
        int nnRpcPort = 8020;
        if (nnServiceName != null) {
            nnRpcPort = NetUtils.createSocketAddr((String)nnServiceName, (int)nnRpcPort).getPort();
        }
        serviceName = SecurityUtil.buildTokenService((InetSocketAddress)NetUtils.createSocketAddrForHost((String)nnUri.getHost(), (int)nnRpcPort));
        return this.selectToken(serviceName, tokens);
    }

    public DelegationTokenSelector() {
        super(DelegationTokenIdentifier.HDFS_DELEGATION_KIND);
    }
}

