/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.server.namenode.ha;

import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.conf.Configuration;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.server.namenode.ha.AbstractNNFailoverProxyProvider;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.server.namenode.ha.HAProxyFactory;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.io.retry.FailoverProxyProvider;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.ipc.RPC;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.List;

public class ConfiguredFailoverProxyProvider<T>
extends AbstractNNFailoverProxyProvider<T> {
    protected final List<AbstractNNFailoverProxyProvider.NNProxyInfo<T>> proxies;
    private int currentProxyIndex = 0;

    public ConfiguredFailoverProxyProvider(Configuration conf, URI uri, Class<T> xface, HAProxyFactory<T> factory) {
        this(conf, uri, xface, factory, "dfs.namenode.rpc-address");
    }

    public ConfiguredFailoverProxyProvider(Configuration conf, URI uri, Class<T> xface, HAProxyFactory<T> factory, String addressKey) {
        super(conf, uri, xface, factory);
        this.proxies = this.getProxyAddresses(uri, addressKey);
    }

    public synchronized FailoverProxyProvider.ProxyInfo<T> getProxy() {
        AbstractNNFailoverProxyProvider.NNProxyInfo<T> current = this.proxies.get(this.currentProxyIndex);
        return this.createProxyIfNeeded(current);
    }

    public void performFailover(T currentProxy) {
        this.incrementProxyIndex();
    }

    synchronized void incrementProxyIndex() {
        this.currentProxyIndex = (this.currentProxyIndex + 1) % this.proxies.size();
    }

    public synchronized void close() throws IOException {
        for (FailoverProxyProvider.ProxyInfo proxyInfo : this.proxies) {
            if (proxyInfo.proxy == null) continue;
            if (proxyInfo.proxy instanceof Closeable) {
                ((Closeable)proxyInfo.proxy).close();
                continue;
            }
            RPC.stopProxy((Object)proxyInfo.proxy);
        }
    }

    @Override
    public boolean useLogicalURI() {
        return true;
    }
}

