/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.server.namenode.ha;

import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.classification.InterfaceAudience;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.classification.InterfaceStability;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.conf.Configuration;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.HAUtilClient;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.protocol.ClientProtocol;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.server.namenode.ha.AbstractNNFailoverProxyProvider;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.server.namenode.ha.HAProxyFactory;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.server.namenode.ha.IPFailoverProxyProvider;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.server.namenode.ha.ObserverReadProxyProvider;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ObserverReadProxyProviderWithIPFailover<T extends ClientProtocol>
extends ObserverReadProxyProvider<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ObserverReadProxyProviderWithIPFailover.class);
    private static final String IPFAILOVER_CONFIG_PREFIX = "dfs.client.failover.ipfailover.virtual-address";

    public ObserverReadProxyProviderWithIPFailover(Configuration conf, URI uri, Class<T> xface, HAProxyFactory<T> factory) {
        this(conf, uri, xface, factory, new IPFailoverProxyProvider<T>(conf, ObserverReadProxyProviderWithIPFailover.getFailoverVirtualIP(conf, uri.getHost()), xface, factory));
    }

    @Override
    public boolean useLogicalURI() {
        return true;
    }

    public ObserverReadProxyProviderWithIPFailover(Configuration conf, URI uri, Class<T> xface, HAProxyFactory<T> factory, AbstractNNFailoverProxyProvider<T> failoverProxy) {
        super(conf, uri, xface, factory, failoverProxy);
        this.cloneDelegationTokenForVirtualIP(conf, uri);
    }

    private void cloneDelegationTokenForVirtualIP(Configuration conf, URI haURI) {
        URI virtualIPURI = ObserverReadProxyProviderWithIPFailover.getFailoverVirtualIP(conf, haURI.getHost());
        InetSocketAddress vipAddress = new InetSocketAddress(virtualIPURI.getHost(), virtualIPURI.getPort());
        HAUtilClient.cloneDelegationTokenForLogicalUri(this.ugi, haURI, Collections.singleton(vipAddress));
    }

    private static URI getFailoverVirtualIP(Configuration conf, String nameServiceID) {
        String configKey = "dfs.client.failover.ipfailover.virtual-address." + nameServiceID;
        String virtualIP = conf.get(configKey);
        LOG.info("Name service ID {} will use virtual IP {} for failover", (Object)nameServiceID, (Object)virtualIP);
        if (virtualIP == null) {
            throw new IllegalArgumentException("Virtual IP for failover not found,misconfigured " + configKey + "?");
        }
        return URI.create(virtualIP);
    }
}

