/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.web;

import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.classification.InterfaceAudience;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.classification.InterfaceStability;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.conf.Configuration;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.security.authentication.client.ConnectionConfigurator;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.security.ssl.SSLFactory;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.security.GeneralSecurityException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class SSLConnectionConfigurator
implements ConnectionConfigurator {
    private final SSLFactory factory;
    private final SSLSocketFactory sf;
    private final HostnameVerifier hv;
    private final int connectTimeout;
    private final int readTimeout;

    SSLConnectionConfigurator(int connectTimeout, int readTimeout, Configuration conf) throws IOException, GeneralSecurityException {
        this.factory = new SSLFactory(SSLFactory.Mode.CLIENT, conf);
        this.factory.init();
        this.sf = this.factory.createSSLSocketFactory();
        this.hv = this.factory.getHostnameVerifier();
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    public HttpURLConnection configure(HttpURLConnection conn) {
        if (conn instanceof HttpsURLConnection) {
            HttpsURLConnection c = (HttpsURLConnection)conn;
            c.setSSLSocketFactory(this.sf);
            c.setHostnameVerifier(this.hv);
        }
        conn.setConnectTimeout(this.connectTimeout);
        conn.setReadTimeout(this.readTimeout);
        return conn;
    }

    void destroy() {
        this.factory.destroy();
    }
}

