/*
 * Decompiled with CFR 0.152.
 */
package consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.hdfs.web.oauth2;

import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.classification.InterfaceAudience;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.classification.InterfaceStability;
import consulting.freiheitsgrade.patched.dependencies.org.apache.hadoop.util.Timer;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class AccessTokenTimer {
    public static final long EXPIRE_BUFFER_MS = 30000L;
    private final Timer timer;
    private long nextRefreshMSSinceEpoch;

    public AccessTokenTimer() {
        this(new Timer());
    }

    public AccessTokenTimer(Timer timer) {
        this.timer = timer;
        this.nextRefreshMSSinceEpoch = 0L;
    }

    public void setExpiresIn(String expiresIn) {
        this.nextRefreshMSSinceEpoch = AccessTokenTimer.convertExpiresIn(this.timer, expiresIn);
    }

    public void setExpiresInMSSinceEpoch(String expiresInMSSinceEpoch) {
        this.nextRefreshMSSinceEpoch = Long.parseLong(expiresInMSSinceEpoch);
    }

    public long getNextRefreshMSSinceEpoch() {
        return this.nextRefreshMSSinceEpoch;
    }

    public boolean shouldRefresh() {
        long lowerLimit = this.nextRefreshMSSinceEpoch - 30000L;
        long currTime = this.timer.now();
        return currTime > lowerLimit;
    }

    static Long convertExpiresIn(Timer timer, String expiresInSecs) {
        long expiresSecs = Long.parseLong(expiresInSecs);
        long expiresMs = expiresSecs * 1000L;
        return timer.now() + expiresMs;
    }
}

